"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Vulnerabilities = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _use_cloud_posture_table = require("../../common/hooks/use_cloud_posture_table");
var _use_latest_vulnerabilities = require("./hooks/use_latest_vulnerabilities");
var _constants2 = require("../../../common/constants");
var _error_callout = require("../configurations/layout/error_callout");
var _findings_search_bar = require("../configurations/layout/findings_search_bar");
var _use_filtered_data_view = require("../../common/api/use_filtered_data_view");
var _vulnerability_badges = require("../../components/vulnerability_badges");
var _empty_state = require("../../components/empty_state");
var _vulnerability_finding_flyout = require("./vulnerabilities_finding_flyout/vulnerability_finding_flyout");
var _no_vulnerabilities_states = require("../../components/no_vulnerabilities_states");
var _use_setup_status_api = require("../../common/api/use_setup_status_api");
var _get_limit_properties = require("../../common/utils/get_limit_properties");
var _findings_layout = require("../configurations/layout/findings_layout");
var _vulnerabilities_table_columns = require("./vulnerabilities_table_columns");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _get_filters = require("./utils/get_filters");
var _translations = require("./translations");
var _custom_sort_script = require("./utils/custom_sort_script");
var _use_page_slice = require("../../common/hooks/use_page_slice");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultQuery = ({
  query,
  filters
}) => ({
  query,
  filters,
  sort: [{
    id: _vulnerabilities_table_columns.vulnerabilitiesColumns.cvss,
    direction: 'desc'
  }],
  pageIndex: 0
});
const Vulnerabilities = () => {
  var _getSetupStatus$data, _getSetupStatus$data$;
  const {
    data,
    isLoading,
    error
  } = (0, _use_filtered_data_view.useFilteredDataView)(_constants2.LATEST_VULNERABILITIES_INDEX_PATTERN);
  const getSetupStatus = (0, _use_setup_status_api.useCspSetupStatusApi)();
  if ((getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$data = getSetupStatus.data) === null || _getSetupStatus$data === void 0 ? void 0 : (_getSetupStatus$data$ = _getSetupStatus$data.vuln_mgmt) === null || _getSetupStatus$data$ === void 0 ? void 0 : _getSetupStatus$data$.status) !== 'indexed') return /*#__PURE__*/_react2.default.createElement(_no_vulnerabilities_states.NoVulnerabilitiesStates, null);
  if (error) {
    return /*#__PURE__*/_react2.default.createElement(_error_callout.ErrorCallout, {
      error: error
    });
  }
  if (isLoading) {
    return (0, _cloud_posture_page.defaultLoadingRenderer)();
  }
  if (!data) {
    return (0, _cloud_posture_page.defaultNoDataRenderer)();
  }
  return /*#__PURE__*/_react2.default.createElement(VulnerabilitiesContent, {
    dataView: data
  });
};
exports.Vulnerabilities = Vulnerabilities;
const VulnerabilitiesContent = ({
  dataView
}) => {
  const {
    pageIndex,
    query,
    sort,
    queryError,
    pageSize,
    onChangeItemsPerPage,
    onChangePage,
    onSort,
    urlQuery,
    setUrlQuery,
    onResetFilters
  } = (0, _use_cloud_posture_table.useCloudPostureTable)({
    dataView,
    defaultQuery: getDefaultQuery,
    paginationLocalStorageKey: _constants.LOCAL_STORAGE_PAGE_SIZE_FINDINGS_KEY
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const multiFieldsSort = (0, _react2.useMemo)(() => {
    return sort.map(({
      id,
      direction
    }) => {
      if (_custom_sort_script.VULNERABILITY_SEVERITY_FIELD === id) {
        return (0, _custom_sort_script.severitySortScript)(direction);
      }
      return {
        [id]: direction
      };
    });
  }, [sort]);
  const {
    data,
    isLoading,
    isFetching
  } = (0, _use_latest_vulnerabilities.useLatestVulnerabilities)({
    query,
    sort: multiFieldsSort,
    enabled: !queryError
  });
  const slicedPage = (0, _use_page_slice.usePageSlice)(data === null || data === void 0 ? void 0 : data.page, pageIndex, pageSize);
  const invalidIndex = -1;
  const selectedVulnerability = (0, _react2.useMemo)(() => {
    return slicedPage[urlQuery.vulnerabilityIndex];
  }, [slicedPage, urlQuery.vulnerabilityIndex]);
  const onCloseFlyout = () => {
    setUrlQuery({
      vulnerabilityIndex: invalidIndex
    });
  };
  const onOpenFlyout = (0, _react2.useCallback)(vulnerabilityRow => {
    const vulnerabilityIndex = slicedPage.findIndex(vulnerabilityRecord => {
      var _vulnerabilityRecord$, _vulnerabilityRow$vul, _vulnerabilityRecord$2, _vulnerabilityRow$res;
      return ((_vulnerabilityRecord$ = vulnerabilityRecord.vulnerability) === null || _vulnerabilityRecord$ === void 0 ? void 0 : _vulnerabilityRecord$.id) === ((_vulnerabilityRow$vul = vulnerabilityRow.vulnerability) === null || _vulnerabilityRow$vul === void 0 ? void 0 : _vulnerabilityRow$vul.id) && ((_vulnerabilityRecord$2 = vulnerabilityRecord.resource) === null || _vulnerabilityRecord$2 === void 0 ? void 0 : _vulnerabilityRecord$2.id) === ((_vulnerabilityRow$res = vulnerabilityRow.resource) === null || _vulnerabilityRow$res === void 0 ? void 0 : _vulnerabilityRow$res.id) && vulnerabilityRecord.vulnerability.package.name === vulnerabilityRow.vulnerability.package.name && vulnerabilityRecord.vulnerability.package.version === vulnerabilityRow.vulnerability.package.version;
    });
    setUrlQuery({
      vulnerabilityIndex
    });
  }, [setUrlQuery, slicedPage]);
  const {
    isLastLimitedPage,
    limitedTotalItemCount
  } = (0, _get_limit_properties.useLimitProperties)({
    total: data === null || data === void 0 ? void 0 : data.total,
    pageIndex,
    pageSize
  });
  const columns = (0, _react2.useMemo)(() => {
    const getColumnIdValue = (rowIndex, columnId) => {
      const vulnerabilityRow = data === null || data === void 0 ? void 0 : data.page[rowIndex];
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.vulnerability) {
        return vulnerabilityRow.vulnerability.id;
      }
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.cvss) {
        return vulnerabilityRow.vulnerability.score.base;
      }
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.resource) {
        var _vulnerabilityRow$res2;
        return (_vulnerabilityRow$res2 = vulnerabilityRow.resource) === null || _vulnerabilityRow$res2 === void 0 ? void 0 : _vulnerabilityRow$res2.name;
      }
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.severity) {
        return vulnerabilityRow.vulnerability.severity;
      }
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.package_version) {
        var _vulnerabilityRow$vul2, _vulnerabilityRow$vul3;
        return (_vulnerabilityRow$vul2 = vulnerabilityRow.vulnerability) === null || _vulnerabilityRow$vul2 === void 0 ? void 0 : (_vulnerabilityRow$vul3 = _vulnerabilityRow$vul2.package) === null || _vulnerabilityRow$vul3 === void 0 ? void 0 : _vulnerabilityRow$vul3.name;
      }
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.fix_version) {
        var _vulnerabilityRow$vul4;
        return (_vulnerabilityRow$vul4 = vulnerabilityRow.vulnerability.package) === null || _vulnerabilityRow$vul4 === void 0 ? void 0 : _vulnerabilityRow$vul4.fixed_version;
      }
    };
    const cellActions = [({
      Component,
      rowIndex,
      columnId
    }) => {
      const value = getColumnIdValue(rowIndex, columnId);
      if (!value) return null;
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _translations.FILTER_IN
      }, /*#__PURE__*/_react2.default.createElement(Component, {
        iconType: "plusInCircle",
        "aria-label": _translations.FILTER_IN,
        onClick: () => {
          setUrlQuery({
            pageIndex: 0,
            filters: (0, _get_filters.getFilters)({
              filters: urlQuery.filters,
              dataView,
              field: columnId,
              value,
              negate: false
            })
          });
        }
      }, _translations.FILTER_IN));
    }, ({
      Component,
      rowIndex,
      columnId
    }) => {
      const value = getColumnIdValue(rowIndex, columnId);
      if (!value) return null;
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _translations.FILTER_OUT
      }, /*#__PURE__*/_react2.default.createElement(Component, {
        iconType: "minusInCircle",
        "aria-label": _translations.FILTER_OUT,
        onClick: () => {
          setUrlQuery({
            pageIndex: 0,
            filters: (0, _get_filters.getFilters)({
              filters: urlQuery.filters,
              dataView,
              field: columnId,
              value: getColumnIdValue(rowIndex, columnId),
              negate: true
            })
          });
        }
      }, _translations.FILTER_OUT));
    }];
    return (0, _vulnerabilities_table_columns.getVulnerabilitiesColumnsGrid)(cellActions);
  }, [data === null || data === void 0 ? void 0 : data.page, dataView, setUrlQuery, urlQuery.filters]);
  const renderCellValue = (0, _react2.useMemo)(() => {
    return ({
      rowIndex,
      columnId
    }) => {
      var _vulnerabilityRow$vul5;
      const vulnerabilityRow = data === null || data === void 0 ? void 0 : data.page[rowIndex];
      if (!vulnerabilityRow) return null;
      if (!((_vulnerabilityRow$vul5 = vulnerabilityRow.vulnerability) !== null && _vulnerabilityRow$vul5 !== void 0 && _vulnerabilityRow$vul5.id)) return null;
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.actions) {
        return /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
          iconType: "expand",
          "aria-label": "View",
          onClick: () => {
            onOpenFlyout(vulnerabilityRow);
          }
        });
      }
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.vulnerability) {
        return vulnerabilityRow.vulnerability.id || '';
      }
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.cvss) {
        var _vulnerabilityRow$vul6;
        if (!((_vulnerabilityRow$vul6 = vulnerabilityRow.vulnerability.score) !== null && _vulnerabilityRow$vul6 !== void 0 && _vulnerabilityRow$vul6.base)) {
          return null;
        }
        return /*#__PURE__*/_react2.default.createElement(_vulnerability_badges.CVSScoreBadge, {
          score: vulnerabilityRow.vulnerability.score.base,
          version: vulnerabilityRow.vulnerability.score.version
        });
      }
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.resource) {
        var _vulnerabilityRow$res3;
        return ((_vulnerabilityRow$res3 = vulnerabilityRow.resource) === null || _vulnerabilityRow$res3 === void 0 ? void 0 : _vulnerabilityRow$res3.name) || null;
      }
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.severity) {
        if (!vulnerabilityRow.vulnerability.severity) {
          return null;
        }
        return /*#__PURE__*/_react2.default.createElement(_vulnerability_badges.SeverityStatusBadge, {
          status: vulnerabilityRow.vulnerability.severity
        });
      }
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.package_version) {
        var _vulnerabilityRow$vul7, _vulnerabilityRow$vul8, _vulnerabilityRow$vul9, _vulnerabilityRow$vul10;
        return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, (_vulnerabilityRow$vul7 = vulnerabilityRow.vulnerability) === null || _vulnerabilityRow$vul7 === void 0 ? void 0 : (_vulnerabilityRow$vul8 = _vulnerabilityRow$vul7.package) === null || _vulnerabilityRow$vul8 === void 0 ? void 0 : _vulnerabilityRow$vul8.name, ' ', (_vulnerabilityRow$vul9 = vulnerabilityRow.vulnerability) === null || _vulnerabilityRow$vul9 === void 0 ? void 0 : (_vulnerabilityRow$vul10 = _vulnerabilityRow$vul9.package) === null || _vulnerabilityRow$vul10 === void 0 ? void 0 : _vulnerabilityRow$vul10.version);
      }
      if (columnId === _vulnerabilities_table_columns.vulnerabilitiesColumns.fix_version) {
        var _vulnerabilityRow$vul11, _vulnerabilityRow$vul12;
        if (!((_vulnerabilityRow$vul11 = vulnerabilityRow.vulnerability.package) !== null && _vulnerabilityRow$vul11 !== void 0 && _vulnerabilityRow$vul11.fixed_version)) {
          return null;
        }
        return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, (_vulnerabilityRow$vul12 = vulnerabilityRow.vulnerability.package) === null || _vulnerabilityRow$vul12 === void 0 ? void 0 : _vulnerabilityRow$vul12.name, ' ', vulnerabilityRow.vulnerability.package.fixed_version);
      }
    };
  }, [data === null || data === void 0 ? void 0 : data.page, onOpenFlyout]);
  const onPaginateFlyout = (0, _react2.useCallback)(nextVulnerabilityIndex => {
    // the index of the vulnerability in the current page
    const newVulnerabilityIndex = nextVulnerabilityIndex % pageSize;

    // if the vulnerability is not in the current page, we need to change the page
    const flyoutPageIndex = Math.floor(nextVulnerabilityIndex / pageSize);
    setUrlQuery({
      pageIndex: flyoutPageIndex,
      vulnerabilityIndex: newVulnerabilityIndex
    });
  }, [pageSize, setUrlQuery]);
  const flyoutVulnerabilityIndex = urlQuery === null || urlQuery === void 0 ? void 0 : urlQuery.vulnerabilityIndex;
  const error = queryError || null;
  if (error) {
    return /*#__PURE__*/_react2.default.createElement(_error_callout.ErrorCallout, {
      error: error
    });
  }
  if (isLoading) {
    return (0, _cloud_posture_page.defaultLoadingRenderer)();
  }
  if (!(data !== null && data !== void 0 && data.page)) {
    return (0, _cloud_posture_page.defaultNoDataRenderer)();
  }
  const showVulnerabilityFlyout = flyoutVulnerabilityIndex > invalidIndex;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_findings_search_bar.FindingsSearchBar, {
    dataView: dataView,
    setQuery: newQuery => {
      setUrlQuery({
        ...newQuery,
        pageIndex: 0
      });
    },
    loading: isLoading,
    placeholder: _translations.SEARCH_BAR_PLACEHOLDER
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), !isLoading && data.page.length === 0 ? /*#__PURE__*/_react2.default.createElement(_empty_state.EmptyState, {
    onResetFilters: onResetFilters
  }) : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, isFetching ? /*#__PURE__*/_react2.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent"
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    css: (0, _react.css)`
                height: 2px;
              `
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiDataGrid, {
    css: (0, _react.css)`
              & .euiDataGridHeaderCell__icon {
                display: none;
              }
              & .euiDataGrid__controls {
                border-bottom: none;
              }
              & .euiButtonIcon {
                color: ${euiTheme.colors.primary};
              }
              & .euiDataGridRowCell {
                font-size: ${euiTheme.size.m};
              }
              &
                .euiDataGridRowCell__expandActions
                > [data-test-subj='euiDataGridCellExpandButton'] {
                display: none;
              }
              & .euiDataGridRowCell__expandFlex {
                align-items: center;
              }
            `,
    "aria-label": _translations.VULNERABILITIES,
    columns: columns,
    columnVisibility: {
      visibleColumns: columns.map(({
        id
      }) => id),
      setVisibleColumns: () => {}
    },
    schemaDetectors: [_custom_sort_script.severitySchemaConfig],
    rowCount: limitedTotalItemCount,
    toolbarVisibility: {
      showColumnSelector: false,
      showDisplaySelector: false,
      showKeyboardShortcuts: false,
      additionalControls: {
        left: {
          prepend: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
            size: "xs",
            color: "text"
          }, _i18n.i18n.translate('xpack.csp.vulnerabilities.totalVulnerabilities', {
            defaultMessage: '{total, plural, one {# Vulnerability} other {# Vulnerabilities}}',
            values: {
              total: data === null || data === void 0 ? void 0 : data.total
            }
          }))
        }
      }
    },
    gridStyle: {
      border: 'horizontal',
      cellPadding: 'l',
      stripes: false,
      rowHover: 'none',
      header: 'underline'
    },
    renderCellValue: renderCellValue,
    inMemory: {
      level: 'pagination'
    },
    sorting: {
      columns: sort,
      onSort
    },
    pagination: {
      pageIndex,
      pageSize,
      pageSizeOptions: [10, 25, 100],
      onChangeItemsPerPage,
      onChangePage
    }
  }), isLastLimitedPage && /*#__PURE__*/_react2.default.createElement(_findings_layout.LimitedResultsBar, null), showVulnerabilityFlyout && /*#__PURE__*/_react2.default.createElement(_vulnerability_finding_flyout.VulnerabilityFindingFlyout, {
    flyoutIndex: flyoutVulnerabilityIndex + pageIndex * pageSize,
    vulnerabilityRecord: selectedVulnerability,
    totalVulnerabilitiesCount: limitedTotalItemCount,
    onPaginate: onPaginateFlyout,
    closeFlyout: onCloseFlyout
  })));
};