"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.severitySortScript = exports.severitySchemaConfig = exports.VULNERABILITY_SEVERITY_FIELD = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VULNERABILITY_SEVERITY_FIELD = 'vulnerability.severity';
exports.VULNERABILITY_SEVERITY_FIELD = VULNERABILITY_SEVERITY_FIELD;
const severitySchemaConfig = {
  type: 'severitySchema',
  detector() {
    return 0; // this schema is always explicitly defined
  },

  sortTextAsc: _i18n.i18n.translate('xpack.csp.vulnerabilityTable.column.sortAscending', {
    defaultMessage: 'Low -> Critical'
  }),
  sortTextDesc: _i18n.i18n.translate('xpack.csp.vulnerabilityTable.column.sortDescending', {
    defaultMessage: 'Critical -> Low'
  }),
  icon: 'dot',
  color: ''
};
exports.severitySchemaConfig = severitySchemaConfig;
const severitySortScript = direction => ({
  _script: {
    type: 'number',
    script: {
      lang: 'painless',
      inline: "if(params.scores.containsKey(doc['vulnerability.severity'].value)) { return params.scores[doc['vulnerability.severity'].value];} return 1000;",
      params: {
        scores: {
          LOW: 0,
          MEDIUM: 1,
          HIGH: 2,
          CRITICAL: 3
        }
      }
    },
    order: direction
  }
});
exports.severitySortScript = severitySortScript;