"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLatestVulnerabilities = exports.getFindingsQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _ioTs = require("io-ts");
var _constants = require("../../../../common/constants");
var _use_kibana = require("../../../common/hooks/use_kibana");
var _show_error_toast = require("../../../common/utils/show_error_toast");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFindingsQuery = ({
  query,
  sort
}) => {
  var _query$bool, _query$bool2;
  return {
    index: _constants.LATEST_VULNERABILITIES_INDEX_PATTERN,
    query: {
      ...query,
      bool: {
        ...(query === null || query === void 0 ? void 0 : query.bool),
        filter: [...((query === null || query === void 0 ? void 0 : (_query$bool = query.bool) === null || _query$bool === void 0 ? void 0 : _query$bool.filter) || []), {
          exists: {
            field: 'vulnerability.score.base'
          }
        }, {
          exists: {
            field: 'vulnerability.score.version'
          }
        }, {
          exists: {
            field: 'vulnerability.severity'
          }
        }, {
          exists: {
            field: 'resource.name'
          }
        }, {
          match_phrase: {
            'vulnerability.enumeration': 'CVE'
          }
        }],
        must_not: [...((query === null || query === void 0 ? void 0 : (_query$bool2 = query.bool) === null || _query$bool2 === void 0 ? void 0 : _query$bool2.must_not) || []), {
          match_phrase: {
            'vulnerability.severity': 'UNKNOWN'
          }
        }]
      }
    },
    size: _constants2.MAX_FINDINGS_TO_LOAD,
    sort
  };
};
exports.getFindingsQuery = getFindingsQuery;
const useLatestVulnerabilities = options => {
  const {
    data,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([_constants.LATEST_VULNERABILITIES_INDEX_PATTERN, {
    params: options
  }], async () => {
    const {
      rawResponse: {
        hits
      }
    } = await (0, _rxjs.lastValueFrom)(data.search.search({
      params: getFindingsQuery(options)
    }));
    return {
      page: hits.hits.map(hit => hit._source),
      total: _ioTs.number.is(hits.total) ? hits.total : 0
    };
  }, {
    enabled: options.enabled,
    keepPreviousData: true,
    onError: err => (0, _show_error_toast.showErrorToast)(toasts, err)
  });
};
exports.useLatestVulnerabilities = useLatestVulnerabilities;