"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindCspRuleTemplates = void 0;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/fleet-plugin/common");
var _helpers = require("../../../common/utils/helpers");
var _constants = require("../../../common/constants");
var _use_kibana = require("../../common/hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFindCspRuleTemplates = ({
  search,
  page,
  perPage,
  filter
}, packagePolicyId) => {
  const {
    savedObjects
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([_constants.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE, {
    search,
    page,
    perPage
  }], () => savedObjects.client.get(_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE, packagePolicyId).then(res => {
    const benchmarkId = (0, _helpers.getBenchmarkFromPackagePolicy)(res.attributes.inputs);
    return savedObjects.client.find({
      type: _constants.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE,
      search: search ? `"${search}"*` : '',
      searchFields: ['metadata.name.text'],
      page: 1,
      sortField: 'metadata.name',
      perPage,
      filter: (0, _helpers.getBenchmarkTypeFilter)(benchmarkId)
    });
  }));
};
exports.useFindCspRuleTemplates = useFindCspRuleTemplates;