"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var TEST_SUBJECTS = _interopRequireWildcard(require("./test_subjects"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesTable = ({
  setPagination,
  setSelectedRuleId,
  perPage: pageSize,
  rules_page: items,
  page,
  total,
  loading,
  error,
  selectedRuleId
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const columns = (0, _react.useMemo)(() => getColumns({
    setSelectedRuleId
  }), [setSelectedRuleId]);
  const euiPagination = {
    pageIndex: page,
    pageSize,
    totalItemCount: total,
    pageSizeOptions: [10, 25, 100]
  };
  const onTableChange = ({
    page: pagination
  }) => {
    if (!pagination) return;
    setPagination({
      page: pagination.index,
      perPage: pagination.size
    });
  };
  const rowProps = row => ({
    ['data-test-subj']: TEST_SUBJECTS.getCspRuleTemplatesTableRowItemTestId(row.id),
    style: {
      background: row.id === selectedRuleId ? euiTheme.colors.highlight : undefined
    },
    onClick: e => {
      const tag = e.target.tagName;
      // Ignore checkbox and switch toggle columns
      if (tag === 'BUTTON' || tag === 'INPUT') return;
      setSelectedRuleId(row.id);
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": TEST_SUBJECTS.CSP_RULES_TABLE,
    loading: loading,
    error: error,
    items: items,
    columns: columns,
    pagination: euiPagination,
    onChange: onTableChange,
    itemId: v => v.id,
    rowProps: rowProps
  });
};
exports.RulesTable = RulesTable;
const getColumns = ({
  setSelectedRuleId
}) => [{
  field: 'attributes.metadata.name',
  name: _i18n.i18n.translate('xpack.csp.rules.rulesTable.nameColumnLabel', {
    defaultMessage: 'Name'
  }),
  width: '60%',
  truncateText: true,
  render: (name, rule) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "eui-textTruncate",
    title: name,
    onClick: e => {
      e.stopPropagation();
      setSelectedRuleId(rule.id);
    },
    "data-test-subj": TEST_SUBJECTS.CSP_RULES_TABLE_ROW_ITEM_NAME
  }, name)
}, {
  field: 'attributes.metadata.section',
  name: _i18n.i18n.translate('xpack.csp.rules.rulesTable.cisSectionColumnLabel', {
    defaultMessage: 'CIS Section'
  }),
  width: '15%'
}];