"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _rule_tab = require("../configurations/findings_flyout/rule_tab");
var _overview_tab = require("../configurations/findings_flyout/overview_tab");
var TEST_SUBJECTS = _interopRequireWildcard(require("./test_subjects"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tabs = [{
  label: _i18n.i18n.translate('xpack.csp.rules.ruleFlyout.overviewTabLabel', {
    defaultMessage: 'Overview'
  }),
  id: 'overview',
  disabled: false
}, {
  label: _i18n.i18n.translate('xpack.csp.rules.ruleFlyout.remediationTabLabel', {
    defaultMessage: 'Remediation'
  }),
  id: 'remediation',
  disabled: false
}];
const RuleFlyout = ({
  onClose,
  rule
}) => {
  const [tab, setTab] = (0, _react.useState)('overview');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: false,
    onClose: onClose,
    "data-test-subj": TEST_SUBJECTS.CSP_RULES_FLYOUT_CONTAINER,
    outsideClickCloses: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", null, rule.attributes.metadata.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabs.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: item.id,
    isSelected: tab === item.id,
    onClick: () => setTab(item.id),
    disabled: item.disabled
  }, item.label)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, tab === 'overview' && /*#__PURE__*/_react.default.createElement(RuleOverviewTab, {
    rule: rule
  }), tab === 'remediation' && /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: false,
    listItems: (0, _overview_tab.getRemediationList)(rule.attributes.metadata)
  })));
};
exports.RuleFlyout = RuleFlyout;
const RuleOverviewTab = ({
  rule
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  listItems: (0, _rule_tab.getRuleList)(rule.attributes.metadata)
})));