"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Findings = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _configurations = require("../configurations");
var _constants = require("../../common/navigation/constants");
var _vulnerabilities = require("../vulnerabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Findings = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const navigateToVulnerabilitiesTab = () => {
    history.push({
      pathname: _constants.findingsNavigation.vulnerabilities.path
    });
  };
  const navigateToConfigurationsTab = () => {
    history.push({
      pathname: _constants.findingsNavigation.findings_default.path
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.title",
    defaultMessage: "Findings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: "vuln_mgmt",
    onClick: navigateToVulnerabilitiesTab,
    isSelected: location.pathname === _constants.findingsNavigation.vulnerabilities.path
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.tabs.vulnerabilities",
    defaultMessage: "Vulnerabilities"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    css: (0, _react2.css)`
                  display: block;
                `,
    label: "Beta",
    tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.findings.betaLabel",
      defaultMessage: "This functionality is in beta and is subject to change. The design and code is less mature than official generally available features and is being provided as-is with no warranties. Beta features are not subject to the support service level agreement of official generally available features."
    }),
    tooltipPosition: "bottom"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: "configurations",
    onClick: navigateToConfigurationsTab,
    isSelected: location.pathname !== _constants.findingsNavigation.vulnerabilities.path
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.tabs.misconfigurations",
    defaultMessage: "Misconfigurations"
  }))), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.cloudPosturePages.findings.path,
    render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: _constants.findingsNavigation.findings_default.path,
        search: location.search
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.findingsNavigation.findings_default.path,
    component: _configurations.Configurations
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.findingsNavigation.vulnerabilities.path,
    component: _vulnerabilities.Vulnerabilities
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.findingsNavigation.findings_by_resource.path,
    component: _configurations.Configurations
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "*",
    render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.findingsNavigation.findings_default.path
    })
  })));
};
exports.Findings = Findings;