"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsDistributionBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _constants = require("../../../../common/constants");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatNumber = value => value < 1000 ? value : (0, _numeral.default)(value).format('0.0a');
const FindingsDistributionBar = props => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(Counters, props), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(DistributionBar, props));
exports.FindingsDistributionBar = FindingsDistributionBar;
const Counters = props => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(CurrentPageOfTotal, props)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 1,
  css: (0, _react2.css)`
        align-items: flex-end;
      `
}, /*#__PURE__*/_react.default.createElement(PassedFailedCounters, props)));
const PassedFailedCounters = ({
  passed,
  failed
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        display: grid;
        grid-template-columns: auto auto;
        grid-column-gap: ${euiTheme.size.m};
      `
  }, /*#__PURE__*/_react.default.createElement(Counter, {
    label: _i18n.i18n.translate('xpack.csp.findings.distributionBar.totalPassedLabel', {
      defaultMessage: 'Passed Findings'
    }),
    color: euiTheme.colors.success,
    value: passed
  }), /*#__PURE__*/_react.default.createElement(Counter, {
    label: _i18n.i18n.translate('xpack.csp.findings.distributionBar.totalFailedLabel', {
      defaultMessage: 'Failed Findings'
    }),
    color: _constants2.statusColors.failed,
    value: failed
  }));
};
const CurrentPageOfTotal = ({
  pageEnd,
  pageStart,
  total,
  type
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.findings.distributionBar.showingPageOfTotalLabel",
  defaultMessage: "Showing {pageStart}-{pageEnd} of {total} {type}",
  values: {
    pageStart: /*#__PURE__*/_react.default.createElement("b", null, pageStart),
    pageEnd: /*#__PURE__*/_react.default.createElement("b", null, pageEnd),
    total: /*#__PURE__*/_react.default.createElement("b", null, formatNumber(total)),
    type
  }
}));
const DistributionBar = ({
  passed,
  failed,
  distributionOnClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: (0, _react2.css)`
        height: 8px;
        background: ${euiTheme.colors.subduedText};
      `
  }, /*#__PURE__*/_react.default.createElement(DistributionBarPart, {
    value: passed,
    color: euiTheme.colors.success,
    distributionOnClick: () => {
      distributionOnClick(_constants.RULE_PASSED);
    },
    "data-test-subj": "distribution_bar_passed"
  }), /*#__PURE__*/_react.default.createElement(DistributionBarPart, {
    value: failed,
    color: _constants2.statusColors.failed,
    distributionOnClick: () => {
      distributionOnClick(_constants.RULE_FAILED);
    },
    "data-test-subj": "distribution_bar_failed"
  }));
};
const DistributionBarPart = ({
  value,
  color,
  distributionOnClick,
  ...rest
}) => /*#__PURE__*/_react.default.createElement("button", {
  "data-test-subj": rest['data-test-subj'],
  onClick: distributionOnClick,
  css: (0, _react2.css)`
      flex: ${value};
      background: ${color};
      height: 100%;
    `
});
const Counter = ({
  label,
  value,
  color
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 1
}, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
  color: color
}, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, formatNumber(value))));