"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResourceFindings = void 0;
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _ioTs = require("io-ts");
var _get_safe_kspm_cluster_id_runtime_mapping = require("../../../../../common/runtime_mappings/get_safe_kspm_cluster_id_runtime_mapping");
var _utils = require("../../utils/utils");
var _use_kibana = require("../../../../common/hooks/use_kibana");
var _constants = require("../../../../../common/constants");
var _constants2 = require("../../../../common/constants");
var _show_error_toast = require("../../../../common/utils/show_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getResourceFindingsQuery = ({
  query,
  resourceId,
  sort
}) => {
  var _query$bool;
  return {
    index: _constants.CSP_LATEST_FINDINGS_DATA_VIEW,
    body: {
      size: _constants2.MAX_FINDINGS_TO_LOAD,
      runtime_mappings: {
        ...(0, _get_safe_kspm_cluster_id_runtime_mapping.getSafeKspmClusterIdRuntimeMapping)()
      },
      query: {
        ...query,
        bool: {
          ...(query === null || query === void 0 ? void 0 : query.bool),
          filter: [...((query === null || query === void 0 ? void 0 : (_query$bool = query.bool) === null || _query$bool === void 0 ? void 0 : _query$bool.filter) || []), {
            term: {
              'resource.id': resourceId
            }
          }]
        }
      },
      sort: [{
        [sort.field]: sort.direction
      }],
      aggs: {
        ...(0, _utils.getFindingsCountAggQuery)(),
        cloudAccountName: {
          terms: {
            field: 'cloud.account.name'
          }
        },
        clusterId: {
          terms: {
            field: 'safe_kspm_cluster_id'
          }
        },
        resourceSubType: {
          terms: {
            field: 'resource.sub_type'
          }
        },
        resourceName: {
          terms: {
            field: 'resource.name'
          }
        }
      }
    },
    ignore_unavailable: false
  };
};
const useResourceFindings = options => {
  const {
    data,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const params = {
    ...options
  };
  return (0, _reactQuery.useQuery)(['csp_resource_findings', {
    params
  }], () => (0, _rxjs.lastValueFrom)(data.search.search({
    params: getResourceFindingsQuery(params)
  })), {
    enabled: options.enabled,
    keepPreviousData: true,
    select: ({
      rawResponse: {
        hits,
        aggregations
      }
    }) => {
      var _aggregations$count, _aggregations$cluster, _aggregations$resourc, _aggregations$resourc2, _aggregations$cloudAc, _aggregations$count2, _aggregations$cluster2, _aggregations$resourc3, _aggregations$resourc4, _aggregations$cloudAc2;
      if (!aggregations) throw new Error('expected aggregations to exists');
      assertNonBucketsArray((_aggregations$count = aggregations.count) === null || _aggregations$count === void 0 ? void 0 : _aggregations$count.buckets);
      assertNonBucketsArray((_aggregations$cluster = aggregations.clusterId) === null || _aggregations$cluster === void 0 ? void 0 : _aggregations$cluster.buckets);
      assertNonBucketsArray((_aggregations$resourc = aggregations.resourceSubType) === null || _aggregations$resourc === void 0 ? void 0 : _aggregations$resourc.buckets);
      assertNonBucketsArray((_aggregations$resourc2 = aggregations.resourceName) === null || _aggregations$resourc2 === void 0 ? void 0 : _aggregations$resourc2.buckets);
      assertNonBucketsArray((_aggregations$cloudAc = aggregations.cloudAccountName) === null || _aggregations$cloudAc === void 0 ? void 0 : _aggregations$cloudAc.buckets);
      return {
        page: hits.hits.map(hit => hit._source),
        total: _ioTs.number.is(hits.total) ? hits.total : 0,
        count: (0, _utils.getAggregationCount)((_aggregations$count2 = aggregations.count) === null || _aggregations$count2 === void 0 ? void 0 : _aggregations$count2.buckets),
        clusterId: getFirstBucketKey((_aggregations$cluster2 = aggregations.clusterId) === null || _aggregations$cluster2 === void 0 ? void 0 : _aggregations$cluster2.buckets),
        resourceSubType: getFirstBucketKey((_aggregations$resourc3 = aggregations.resourceSubType) === null || _aggregations$resourc3 === void 0 ? void 0 : _aggregations$resourc3.buckets),
        resourceName: getFirstBucketKey((_aggregations$resourc4 = aggregations.resourceName) === null || _aggregations$resourc4 === void 0 ? void 0 : _aggregations$resourc4.buckets),
        cloudAccountName: getFirstBucketKey((_aggregations$cloudAc2 = aggregations.cloudAccountName) === null || _aggregations$cloudAc2 === void 0 ? void 0 : _aggregations$cloudAc2.buckets)
      };
    },
    onError: err => (0, _show_error_toast.showErrorToast)(toasts, err)
  });
};
exports.useResourceFindings = useResourceFindings;
function assertNonBucketsArray(arr) {
  if (!Array.isArray(arr)) {
    throw new Error('expected buckets to be an array');
  }
}
const getFirstBucketKey = buckets => {
  var _buckets$;
  return (_buckets$ = buckets[0]) === null || _buckets$ === void 0 ? void 0 : _buckets$.key;
};