"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var TEST_SUBJECTS = _interopRequireWildcard(require("../test_subjects"));
var _findings_flyout = require("../findings_flyout/findings_flyout");
var _findings_layout = require("../layout/findings_layout");
var _utils = require("../utils/utils");
var _empty_state = require("../../../components/empty_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FindingsTableComponent = ({
  loading,
  items,
  pagination,
  sorting,
  setTableOptions,
  onAddFilter,
  onOpenFlyout,
  flyoutFindingIndex,
  onPaginateFlyout,
  onCloseFlyout,
  onResetFilters
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const selectedFinding = items[flyoutFindingIndex];
  const getRowProps = row => ({
    'data-test-subj': TEST_SUBJECTS.getFindingsTableRowTestId(row.resource.id),
    style: (0, _utils.getSelectedRowStyle)(euiTheme, row, selectedFinding)
  });
  const getCellProps = (row, column) => ({
    'data-test-subj': TEST_SUBJECTS.getFindingsTableCellTestId(column.field, row.resource.id)
  });
  const columns = (0, _react.useMemo)(() => [(0, _findings_layout.getExpandColumn)({
    onClick: onOpenFlyout
  }), (0, _findings_layout.createColumnWithFilters)(_findings_layout.baseFindingsColumns['result.evaluation'], {
    onAddFilter
  }), (0, _findings_layout.createColumnWithFilters)(_findings_layout.baseFindingsColumns['resource.id'], {
    onAddFilter
  }), (0, _findings_layout.createColumnWithFilters)(_findings_layout.baseFindingsColumns['resource.name'], {
    onAddFilter
  }), (0, _findings_layout.createColumnWithFilters)(_findings_layout.baseFindingsColumns['resource.sub_type'], {
    onAddFilter
  }), _findings_layout.baseFindingsColumns['rule.benchmark.rule_number'], (0, _findings_layout.createColumnWithFilters)(_findings_layout.baseFindingsColumns['rule.name'], {
    onAddFilter
  }), (0, _findings_layout.createColumnWithFilters)(_findings_layout.baseFindingsColumns['rule.section'], {
    onAddFilter
  }), _findings_layout.baseFindingsColumns['@timestamp']], [onOpenFlyout, onAddFilter]);
  if (!loading && !items.length) {
    return /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, {
      onResetFilters: onResetFilters
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: loading,
    "data-test-subj": TEST_SUBJECTS.LATEST_FINDINGS_TABLE,
    items: items,
    columns: columns,
    pagination: pagination,
    sorting: sorting,
    onChange: setTableOptions,
    rowProps: getRowProps,
    cellProps: getCellProps,
    hasActions: true
  }), selectedFinding && /*#__PURE__*/_react.default.createElement(_findings_flyout.FindingsRuleFlyout, {
    findings: selectedFinding,
    onClose: onCloseFlyout,
    findingsCount: pagination.totalItemCount,
    flyoutIndex: flyoutFindingIndex + pagination.pageIndex * pagination.pageSize,
    onPaginate: onPaginateFlyout
  }));
};
const FindingsTable = /*#__PURE__*/_react.default.memo(FindingsTableComponent);
exports.FindingsTable = FindingsTable;