"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultQuery = exports.LatestFindingsContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _latest_findings_table = require("./latest_findings_table");
var _findings_search_bar = require("../layout/findings_search_bar");
var TEST_SUBJECTS = _interopRequireWildcard(require("../test_subjects"));
var _use_latest_findings = require("./use_latest_findings");
var _findings_distribution_bar = require("../layout/findings_distribution_bar");
var _utils = require("../utils/utils");
var _findings_layout = require("../layout/findings_layout");
var _findings_group_by_selector = require("../layout/findings_group_by_selector");
var _use_page_slice = require("../../../common/hooks/use_page_slice");
var _error_callout = require("../layout/error_callout");
var _get_limit_properties = require("../../../common/utils/get_limit_properties");
var _constants = require("../../../common/constants");
var _use_cloud_posture_table = require("../../../common/hooks/use_cloud_posture_table");
var _utils2 = require("../../../common/hooks/use_cloud_posture_table/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultQuery = ({
  query,
  filters
}) => ({
  query,
  filters,
  sort: {
    field: '@timestamp',
    direction: 'desc'
  },
  pageIndex: 0,
  findingIndex: -1
});
exports.getDefaultQuery = getDefaultQuery;
const LatestFindingsContainer = ({
  dataView
}) => {
  var _findingsGroupByNone$, _findingsGroupByNone$2;
  const {
    pageIndex,
    query,
    sort,
    queryError,
    pageSize,
    setTableOptions,
    urlQuery,
    setUrlQuery,
    filters,
    onResetFilters
  } = (0, _use_cloud_posture_table.useCloudPostureTable)({
    dataView,
    defaultQuery: getDefaultQuery,
    paginationLocalStorageKey: _constants.LOCAL_STORAGE_PAGE_SIZE_FINDINGS_KEY
  });

  /**
   * Page ES query result
   */
  const findingsGroupByNone = (0, _use_latest_findings.useLatestFindings)({
    query,
    sort,
    enabled: !queryError
  });
  const slicedPage = (0, _use_page_slice.usePageSlice)((_findingsGroupByNone$ = findingsGroupByNone.data) === null || _findingsGroupByNone$ === void 0 ? void 0 : _findingsGroupByNone$.page, pageIndex, pageSize);
  const error = findingsGroupByNone.error || queryError;
  const {
    isLastLimitedPage,
    limitedTotalItemCount
  } = (0, _get_limit_properties.useLimitProperties)({
    total: (_findingsGroupByNone$2 = findingsGroupByNone.data) === null || _findingsGroupByNone$2 === void 0 ? void 0 : _findingsGroupByNone$2.total,
    pageIndex,
    pageSize
  });
  const handleDistributionClick = evaluation => {
    setUrlQuery({
      pageIndex: 0,
      filters: (0, _utils.getFilters)({
        filters,
        dataView,
        field: 'result.evaluation',
        value: evaluation,
        negate: false
      })
    });
  };
  const flyoutFindingIndex = urlQuery === null || urlQuery === void 0 ? void 0 : urlQuery.findingIndex;
  const pagination = (0, _utils2.getPaginationTableParams)({
    pageSize,
    pageIndex,
    totalItemCount: limitedTotalItemCount
  });
  const onOpenFlyout = (0, _react.useCallback)(flyoutFinding => {
    setUrlQuery({
      findingIndex: slicedPage.findIndex(finding => finding.resource.id === (flyoutFinding === null || flyoutFinding === void 0 ? void 0 : flyoutFinding.resource.id) && finding.rule.id === (flyoutFinding === null || flyoutFinding === void 0 ? void 0 : flyoutFinding.rule.id))
    });
  }, [slicedPage, setUrlQuery]);
  const onCloseFlyout = () => setUrlQuery({
    findingIndex: -1
  });
  const onPaginateFlyout = (0, _react.useCallback)(nextFindingIndex => {
    // the index of the finding in the current page
    const newFindingIndex = nextFindingIndex % pageSize;

    // if the finding is not in the current page, we need to change the page
    const flyoutPageIndex = Math.floor(nextFindingIndex / pageSize);
    setUrlQuery({
      pageIndex: flyoutPageIndex,
      findingIndex: newFindingIndex
    });
  }, [pageSize, setUrlQuery]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": TEST_SUBJECTS.LATEST_FINDINGS_CONTAINER
  }, /*#__PURE__*/_react.default.createElement(_findings_search_bar.FindingsSearchBar, {
    dataView: dataView,
    setQuery: newQuery => {
      setUrlQuery({
        ...newQuery,
        pageIndex: 0
      });
    },
    loading: findingsGroupByNone.isFetching
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 400
    }
  }, !error && /*#__PURE__*/_react.default.createElement(_findings_group_by_selector.FindingsGroupBySelector, {
    type: "default"
  }))), error && /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
    error: error
  }), !error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, findingsGroupByNone.isSuccess && !!findingsGroupByNone.data.page.length && /*#__PURE__*/_react.default.createElement(_findings_distribution_bar.FindingsDistributionBar, (0, _extends2.default)({
    distributionOnClick: handleDistributionClick,
    type: _i18n.i18n.translate('xpack.csp.findings.latestFindings.tableRowTypeLabel', {
      defaultMessage: 'Findings'
    }),
    total: findingsGroupByNone.data.total,
    passed: findingsGroupByNone.data.count.passed,
    failed: findingsGroupByNone.data.count.failed
  }, (0, _utils.getFindingsPageSizeInfo)({
    pageIndex,
    pageSize,
    currentPageSize: slicedPage.length
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_latest_findings_table.FindingsTable, {
    onResetFilters: onResetFilters,
    onCloseFlyout: onCloseFlyout,
    onPaginateFlyout: onPaginateFlyout,
    onOpenFlyout: onOpenFlyout,
    flyoutFindingIndex: flyoutFindingIndex,
    loading: findingsGroupByNone.isFetching,
    items: slicedPage,
    pagination: pagination,
    sorting: {
      sort: {
        field: sort.field,
        direction: sort.direction
      }
    },
    setTableOptions: setTableOptions,
    onAddFilter: (field, value, negate) => setUrlQuery({
      pageIndex: 0,
      filters: (0, _utils.getFilters)({
        filters,
        dataView,
        field,
        value,
        negate
      })
    })
  })), isLastLimitedPage && /*#__PURE__*/_react.default.createElement(_findings_layout.LimitedResultsBar, null));
};
exports.LatestFindingsContainer = LatestFindingsContainer;