"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPolicyTemplateQuery = exports.dashboardColumnsGrow = exports.SummarySection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _constants = require("../../../common/constants");
var _test_subjects = require("../test_subjects");
var _csp_counter_card = require("../../../components/csp_counter_card");
var _compact_formatted_number = require("../../../components/compact_formatted_number");
var _chart_panel = require("../../../components/chart_panel");
var _compliance_score_chart = require("../compliance_charts/compliance_score_chart");
var _risks_table = require("../compliance_charts/risks_table");
var _use_navigate_findings = require("../../../common/hooks/use_navigate_findings");
var _constants2 = require("../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dashboardColumnsGrow = {
  first: 3,
  second: 8,
  third: 8
};
exports.dashboardColumnsGrow = dashboardColumnsGrow;
const getPolicyTemplateQuery = policyTemplate => {
  if (policyTemplate === _constants2.CSPM_POLICY_TEMPLATE) {
    return {
      'rule.benchmark.posture_type': _constants2.CSPM_POLICY_TEMPLATE
    };
  }
  return {
    'rule.benchmark.posture_type': {
      value: _constants2.CSPM_POLICY_TEMPLATE,
      negate: true
    }
  };
};
exports.getPolicyTemplateQuery = getPolicyTemplateQuery;
const SummarySection = ({
  dashboardType,
  complianceData
}) => {
  const navToFindings = (0, _use_navigate_findings.useNavigateFindings)();
  const navToFindingsByResource = (0, _use_navigate_findings.useNavigateFindingsByResource)();
  const handleEvalCounterClick = evaluation => {
    navToFindings({
      'result.evaluation': evaluation,
      ...getPolicyTemplateQuery(dashboardType)
    });
  };
  const handleCellClick = ruleSection => {
    navToFindings({
      'rule.section': ruleSection,
      'result.evaluation': _constants2.RULE_FAILED,
      ...getPolicyTemplateQuery(dashboardType)
    });
  };
  const handleViewAllClick = () => {
    navToFindings({
      'result.evaluation': _constants2.RULE_FAILED,
      ...getPolicyTemplateQuery(dashboardType)
    });
  };
  const counters = (0, _react.useMemo)(() => [{
    id: _test_subjects.DASHBOARD_COUNTER_CARDS.CLUSTERS_EVALUATED,
    description: dashboardType === _constants2.KSPM_POLICY_TEMPLATE ? _i18n.i18n.translate('xpack.csp.dashboard.summarySection.counterCard.clustersEvaluatedDescription', {
      defaultMessage: 'Clusters Evaluated'
    }) : _i18n.i18n.translate('xpack.csp.dashboard.summarySection.counterCard.accountsEvaluatedDescription', {
      defaultMessage: 'Accounts Evaluated'
    }),
    title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
      number: complianceData.clusters.length
    })
  }, {
    id: _test_subjects.DASHBOARD_COUNTER_CARDS.RESOURCES_EVALUATED,
    description: _i18n.i18n.translate('xpack.csp.dashboard.summarySection.counterCard.resourcesEvaluatedDescription', {
      defaultMessage: 'Resources Evaluated'
    }),
    title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
      number: complianceData.stats.resourcesEvaluated || 0
    }),
    onClick: () => {
      navToFindingsByResource(getPolicyTemplateQuery(dashboardType));
    }
  }, {
    id: _test_subjects.DASHBOARD_COUNTER_CARDS.FAILING_FINDINGS,
    description: _i18n.i18n.translate('xpack.csp.dashboard.summarySection.counterCard.failingFindingsDescription', {
      defaultMessage: 'Failing Findings'
    }),
    title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
      number: complianceData.stats.totalFailed
    }),
    titleColor: complianceData.stats.totalFailed > 0 ? _constants.statusColors.failed : 'text',
    onClick: () => {
      navToFindings({
        'result.evaluation': _constants2.RULE_FAILED,
        ...getPolicyTemplateQuery(dashboardType)
      });
    }
  }], [complianceData.clusters.length, complianceData.stats.resourcesEvaluated, complianceData.stats.totalFailed, dashboardType, navToFindings, navToFindingsByResource]);
  const chartTitle = _i18n.i18n.translate('xpack.csp.dashboard.summarySection.postureScorePanelTitle', {
    defaultMessage: 'Overall {type} Posture Score',
    values: {
      type: dashboardType === _constants2.KSPM_POLICY_TEMPLATE ? 'Kubernetes' : 'Cloud'
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    css: (0, _react2.css)`
        // height for compliance by cis section with max rows
        height: 310px;
      `,
    "data-test-subj": _test_subjects.DASHBOARD_SUMMARY_CONTAINER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: dashboardColumnsGrow.first
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, counters.map(counter => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: counter.id
  }, /*#__PURE__*/_react.default.createElement(_csp_counter_card.CspCounterCard, counter))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: dashboardColumnsGrow.second
  }, /*#__PURE__*/_react.default.createElement(_chart_panel.ChartPanel, {
    title: chartTitle
  }, /*#__PURE__*/_react.default.createElement(_compliance_score_chart.ComplianceScoreChart, {
    id: "cloud_posture_score_chart",
    data: complianceData.stats,
    trend: complianceData.trend,
    onEvalCounterClick: handleEvalCounterClick
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: dashboardColumnsGrow.third
  }, /*#__PURE__*/_react.default.createElement(_chart_panel.ChartPanel, {
    title: _i18n.i18n.translate('xpack.csp.dashboard.summarySection.complianceByCisSectionPanelTitle', {
      defaultMessage: 'Compliance By CIS Section'
    })
  }, /*#__PURE__*/_react.default.createElement(_risks_table.RisksTable, {
    data: complianceData.groupedFindingsEvaluation,
    maxItems: 5,
    onCellClick: handleCellClick,
    onViewAllClick: handleViewAllClick,
    viewAllButtonTitle: _i18n.i18n.translate('xpack.csp.dashboard.risksTable.viewAllButtonTitle', {
      defaultMessage: 'View all failed findings'
    })
  }))));
};
exports.SummarySection = SummarySection;