"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterDetailsBox = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _benchmarks_section = require("./benchmarks_section");
var _constants = require("../../../../common/constants");
var _use_navigate_findings = require("../../../common/hooks/use_navigate_findings");
var _cis_benchmark_icon = require("../../../components/cis_benchmark_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultClusterTitle = _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.defaultClusterTitle', {
  defaultMessage: 'ID'
});
const getClusterTitle = cluster => {
  var _cluster$meta$cluster;
  if (cluster.meta.benchmark.posture_type === _constants.CSPM_POLICY_TEMPLATE) {
    var _cluster$meta$cloud;
    return (_cluster$meta$cloud = cluster.meta.cloud) === null || _cluster$meta$cloud === void 0 ? void 0 : _cluster$meta$cloud.account.name;
  }
  return (_cluster$meta$cluster = cluster.meta.cluster) === null || _cluster$meta$cluster === void 0 ? void 0 : _cluster$meta$cluster.name;
};
const getClusterId = cluster => {
  const assetIdentifierId = cluster.meta.assetIdentifierId;
  if (cluster.meta.benchmark.posture_type === _constants.CSPM_POLICY_TEMPLATE) return assetIdentifierId;
  return assetIdentifierId.slice(0, 6);
};
const ClusterDetailsBox = ({
  cluster
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const navToFindings = (0, _use_navigate_findings.useNavigateFindings)();
  const assetId = getClusterId(cluster);
  const title = getClusterTitle(cluster) || defaultClusterTitle;
  const handleClusterTitleClick = () => {
    return navToFindings((0, _benchmarks_section.getClusterIdQuery)(cluster));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.dashboard.benchmarkSection.clusterTitleTooltip.clusterPrefixTitle",
      defaultMessage: "Show all findings for "
    }), /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.dashboard.benchmarkSection.clusterTitleTooltip.clusterTitle",
      defaultMessage: "{title} - {assetId}",
      values: {
        title,
        assetId
      }
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: handleClusterTitleClick,
    color: "text"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    css: {
      fontSize: 20
    }
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dashboard.benchmarkSection.clusterTitle",
    defaultMessage: "{title} - {assetId}",
    values: {
      title,
      assetId
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dashboard.benchmarkSection.lastEvaluatedTitle",
    defaultMessage: "Last evaluated {dateFromNow}",
    values: {
      dateFromNow: (0, _moment.default)(cluster.meta.lastUpdate).fromNow()
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      justifyContent: 'flex-end',
      paddingBottom: euiTheme.size.m
    }
  }, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
    type: cluster.meta.benchmark.id,
    name: cluster.meta.benchmark.name
  })), _constants.INTERNAL_FEATURE_FLAGS.showManageRulesMock && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dashboard.benchmarkSection.manageRulesButton",
    defaultMessage: "Manage Rules"
  }))));
};
exports.ClusterDetailsBox = ClusterDetailsBox;