"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComplianceScoreChart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _test_subjects = require("../test_subjects");
var _constants = require("../../../common/constants");
var _constants2 = require("../../../../common/constants");
var _compact_formatted_number = require("../../../components/compact_formatted_number");
var _use_kibana = require("../../../common/hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPostureScorePercentage = postureScore => `${Math.round(postureScore)}%`;
const PercentageInfo = ({
  compact,
  postureScore
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const percentage = getPostureScorePercentage(postureScore);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    css: {
      fontSize: compact ? euiTheme.size.l : euiTheme.size.xxl,
      paddingLeft: compact ? euiTheme.size.s : euiTheme.size.xs,
      marginBottom: compact ? euiTheme.size.s : 'none'
    },
    "data-test-subj": _test_subjects.DASHBOARD_COMPLIANCE_SCORE_CHART.COMPLIANCE_SCORE
  }, /*#__PURE__*/_react.default.createElement("h3", null, percentage));
};
const convertTrendToEpochTime = trend => ({
  ...trend,
  timestamp: (0, _moment.default)(trend.timestamp).valueOf()
});
const ComplianceTrendChart = ({
  trend
}) => {
  const epochTimeTrend = trend.map(convertTrendToEpochTime);
  const {
    services: {
      charts
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: charts.theme.useChartsTheme(),
    baseTheme: charts.theme.useChartsBaseTheme(),
    showLegend: false,
    legendPosition: "right",
    tooltip: {
      headerFormatter: ({
        value
      }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: value,
        month: "short",
        day: "numeric"
      }), ', ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: value
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries
  // EuiChart is using this id in the tooltip label
  , {
    id: "Posture Score",
    data: epochTimeTrend,
    xScaleType: "time",
    xAccessor: 'timestamp',
    yAccessors: ['postureScore']
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: (0, _charts.timeFormatter)((0, _charts.niceTimeFormatByDay)(2)),
    ticks: 4
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    ticks: 3,
    id: "left-axis",
    position: "left",
    showGridLines: true,
    domain: {
      min: 0,
      max: 100
    }
  }));
};
const CounterLink = ({
  text,
  count,
  color,
  onClick,
  tooltipContent
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "text",
    onClick: onClick,
    css: {
      display: 'flex'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: color,
    style: {
      fontWeight: euiTheme.font.weight.medium
    },
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
    number: count,
    abbreviateAbove: 999
  }), "\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, text)));
};
const ComplianceScoreChart = ({
  data,
  trend,
  onEvalCounterClick,
  compact
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceBetween",
    style: {
      height: '100%'
    },
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(PercentageInfo, (0, _extends2.default)({}, data, {
    compact: compact
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "none",
    alignItems: "flexStart",
    style: {
      paddingRight: euiTheme.size.xl
    }
  }, /*#__PURE__*/_react.default.createElement(CounterLink, {
    text: "passed",
    count: data.totalPassed,
    color: _constants.statusColors.passed,
    onClick: () => onEvalCounterClick(_constants2.RULE_PASSED),
    tooltipContent: _i18n.i18n.translate('xpack.csp.complianceScoreChart.counterLink.passedFindingsTooltip', {
      defaultMessage: 'Passed findings'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, "\xA0-\xA0"), /*#__PURE__*/_react.default.createElement(CounterLink, {
    text: "failed",
    count: data.totalFailed,
    color: _constants.statusColors.failed,
    onClick: () => onEvalCounterClick(_constants2.RULE_FAILED),
    tooltipContent: _i18n.i18n.translate('xpack.csp.complianceScoreChart.counterLink.failedFindingsTooltip', {
      defaultMessage: 'Failed findings'
    })
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(ComplianceTrendChart, {
    trend: trend
  })));
};
exports.ComplianceScoreChart = ComplianceScoreChart;