"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Benchmarks = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/fleet-plugin/public");
var _constants = require("../../../common/constants");
var _cloud_posture_page_title = require("../../components/cloud_posture_page_title");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _benchmarks_table = require("./benchmarks_table");
var _use_csp_benchmark_integrations = require("./use_csp_benchmark_integrations");
var _helpers = require("../../../common/utils/helpers");
var TEST_SUBJ = _interopRequireWildcard(require("./test_subjects"));
var _constants2 = require("../../common/constants");
var _use_page_size = require("../../common/hooks/use_page_size");
var _use_kibana = require("../../common/hooks/use_kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_DEBOUNCE_MS = 300;
const AddCisIntegrationButton = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const integrationsPath = _public.pagePathGetters.integrations_all({
    searchTerm: _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME
  }).join('');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": TEST_SUBJ.ADD_INTEGRATION_TEST_SUBJ,
    fill: true,
    iconType: "plusInCircle",
    href: http.basePath.prepend(integrationsPath)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.benchmarks.benchmarksPageHeader.addIntegrationButtonLabel",
    defaultMessage: "Add Integration"
  }));
};
const BenchmarkEmptyState = ({
  name
}) => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.benchmarks.benchmarkEmptyState.integrationsNotFoundTitle",
  defaultMessage: "No benchmark integrations found"
}), name && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.benchmarks.benchmarkEmptyState.integrationsNotFoundForNameTitle",
  defaultMessage: " for \"{name}\"",
  values: {
    name
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.benchmarks.benchmarkEmptyState.integrationsNotFoundWithFiltersTitle",
  defaultMessage: "We weren't able to find any benchmark integrations with the above filters."
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}));
const TotalIntegrationsCount = ({
  pageCount,
  totalCount
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  style: {
    marginLeft: 8
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.benchmarks.totalIntegrationsCountMessage",
  defaultMessage: "Showing {pageCount} of {totalCount, plural, one {# integration} other {# integrations}}",
  values: {
    pageCount,
    totalCount
  }
})));
const BenchmarkSearchField = ({
  onSearch,
  isLoading
}) => {
  const [localValue, setLocalValue] = (0, _react.useState)('');
  (0, _useDebounce.default)(() => onSearch(localValue), SEARCH_DEBOUNCE_MS, [localValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      alignItems: 'flex-end'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    fullWidth: true,
    onSearch: setLocalValue,
    isLoading: isLoading,
    placeholder: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarkSearchField.searchPlaceholder', {
      defaultMessage: 'Search by Integration Name'
    }),
    incremental: true
  })));
};
const Benchmarks = () => {
  var _queryResult$data, _queryResult$data2, _queryResult$data3;
  const {
    pageSize,
    setPageSize
  } = (0, _use_page_size.usePageSize)(_constants2.LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY);
  const [query, setQuery] = (0, _react.useState)({
    name: '',
    page: 1,
    perPage: pageSize,
    sortField: 'package_policy.name',
    sortOrder: 'asc'
  });
  const queryResult = (0, _use_csp_benchmark_integrations.useCspBenchmarkIntegrations)(query);
  const totalItemCount = ((_queryResult$data = queryResult.data) === null || _queryResult$data === void 0 ? void 0 : _queryResult$data.total) || 0;
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": TEST_SUBJ.BENCHMARKS_PAGE_HEADER,
    pageTitle: /*#__PURE__*/_react.default.createElement(_cloud_posture_page_title.CloudPosturePageTitle, {
      title: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksPageHeader.benchmarkIntegrationsTitle', {
        defaultMessage: 'Benchmark Integrations'
      })
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(AddCisIntegrationButton, null)],
    bottomBorder: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(BenchmarkSearchField, {
    isLoading: queryResult.isFetching,
    onSearch: name => setQuery(current => ({
      ...current,
      name
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(TotalIntegrationsCount, {
    pageCount: (((_queryResult$data2 = queryResult.data) === null || _queryResult$data2 === void 0 ? void 0 : _queryResult$data2.items) || []).length,
    totalCount: totalItemCount
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_benchmarks_table.BenchmarksTable, {
    benchmarks: ((_queryResult$data3 = queryResult.data) === null || _queryResult$data3 === void 0 ? void 0 : _queryResult$data3.items) || [],
    "data-test-subj": TEST_SUBJ.BENCHMARKS_TABLE_DATA_TEST_SUBJ,
    error: queryResult.error ? (0, _helpers.extractErrorMessage)(queryResult.error) : undefined,
    loading: queryResult.isFetching,
    pageIndex: query.page,
    pageSize: pageSize || query.perPage,
    sorting: {
      // @ts-expect-error - EUI types currently do not support sorting by nested fields
      sort: {
        field: query.sortField,
        direction: query.sortOrder
      },
      allowNeutralSort: false
    },
    totalItemCount: totalItemCount,
    setQuery: ({
      page,
      sort
    }) => {
      setPageSize(page.size);
      setQuery(current => ({
        ...current,
        page: page.index,
        perPage: page.size,
        sortField: (sort === null || sort === void 0 ? void 0 : sort.field) || current.sortField,
        sortOrder: (sort === null || sort === void 0 ? void 0 : sort.direction) || current.sortOrder
      }));
    },
    noItemsMessage: queryResult.isSuccess && !queryResult.data.total ? /*#__PURE__*/_react.default.createElement(BenchmarkEmptyState, {
      name: query.name
    }) : undefined
  }));
};
exports.Benchmarks = Benchmarks;