"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPostureInput = exports.hasPolicyTemplateInputs = exports.getVulnMgmtCloudFormationDefaultValue = exports.getPosturePolicy = exports.getPostureInputHiddenVars = exports.getPolicyTemplateInputOptions = exports.POSTURE_NAMESPACE = void 0;
var _merge = _interopRequireDefault(require("lodash/merge"));
var _constants = require("../../../common/constants");
var _aws_credentials_form = require("./aws_credentials_form");
var _constants2 = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Posture policies only support the default namespace
const POSTURE_NAMESPACE = 'default';
exports.POSTURE_NAMESPACE = POSTURE_NAMESPACE;
const isPostureInput = input => _constants.SUPPORTED_POLICY_TEMPLATES.includes(input.policy_template) && _constants.SUPPORTED_CLOUDBEAT_INPUTS.includes(input.type);
exports.isPostureInput = isPostureInput;
const getPostureType = policyTemplateInput => {
  switch (policyTemplateInput) {
    case _constants.CLOUDBEAT_AWS:
    case _constants.CLOUDBEAT_AZURE:
    case _constants.CLOUDBEAT_GCP:
      return 'cspm';
    case _constants.CLOUDBEAT_VANILLA:
    case _constants.CLOUDBEAT_EKS:
      return 'kspm';
    case _constants.CLOUDBEAT_VULN_MGMT_AWS:
      return 'vuln_mgmt';
    default:
      return 'n/a';
  }
};
const getDeploymentType = policyTemplateInput => {
  switch (policyTemplateInput) {
    case _constants.CLOUDBEAT_AWS:
    case _constants.CLOUDBEAT_VULN_MGMT_AWS:
      return 'aws';
    case _constants.CLOUDBEAT_AZURE:
      return 'azure';
    case _constants.CLOUDBEAT_GCP:
      return 'gcp';
    case _constants.CLOUDBEAT_VANILLA:
      return 'self_managed';
    case _constants.CLOUDBEAT_EKS:
      return 'eks';
    default:
      return 'n/a';
  }
};
const getPostureInput = (input, inputType, inputVars) => {
  const isInputEnabled = input.type === inputType;
  return {
    ...input,
    enabled: isInputEnabled,
    streams: input.streams.map(stream => ({
      ...stream,
      enabled: isInputEnabled,
      // Merge new vars with existing vars
      ...(isInputEnabled && stream.vars && inputVars && {
        vars: (0, _merge.default)({}, stream.vars, inputVars)
      })
    }))
  };
};

/**
 * Get a new object with the updated policy input and vars
 */
const getPosturePolicy = (newPolicy, inputType, inputVars) => ({
  ...newPolicy,
  namespace: POSTURE_NAMESPACE,
  // Enable new policy input and disable all others
  inputs: newPolicy.inputs.map(item => getPostureInput(item, inputType, inputVars)),
  // Set hidden policy vars
  vars: (0, _merge.default)({}, newPolicy.vars, {
    deployment: {
      value: getDeploymentType(inputType)
    },
    posture: {
      value: getPostureType(inputType)
    }
  })
});
exports.getPosturePolicy = getPosturePolicy;
// type guard for checking inputs
const hasPolicyTemplateInputs = policyTemplate => {
  return policyTemplate.hasOwnProperty('inputs');
};
exports.hasPolicyTemplateInputs = hasPolicyTemplateInputs;
const getVulnMgmtCloudFormationDefaultValue = packageInfo => {
  if (!packageInfo.policy_templates) return '';
  const vulnMgmtPolicyTemplate = packageInfo.policy_templates.find(p => p.name === _constants.VULN_MGMT_POLICY_TEMPLATE);
  if (!vulnMgmtPolicyTemplate) return '';
  const vulnMgmtInputs = hasPolicyTemplateInputs(vulnMgmtPolicyTemplate) && vulnMgmtPolicyTemplate.inputs;
  if (!vulnMgmtInputs) return '';
  const cloudFormationTemplate = vulnMgmtInputs.reduce((acc, input) => {
    var _input$vars$find;
    if (!input.vars) return acc;
    const template = (_input$vars$find = input.vars.find(v => v.name === 'cloud_formation_template')) === null || _input$vars$find === void 0 ? void 0 : _input$vars$find.default;
    return template ? String(template) : acc;
  }, '');
  return cloudFormationTemplate;
};

/**
 * Input vars that are hidden from the user
 */
exports.getVulnMgmtCloudFormationDefaultValue = getVulnMgmtCloudFormationDefaultValue;
const getPostureInputHiddenVars = inputType => {
  switch (inputType) {
    case 'cloudbeat/cis_aws':
    case 'cloudbeat/cis_eks':
      return {
        'aws.credentials.type': {
          value: _aws_credentials_form.DEFAULT_AWS_VARS_GROUP
        }
      };
    default:
      return undefined;
  }
};
exports.getPostureInputHiddenVars = getPostureInputHiddenVars;
const getPolicyTemplateInputOptions = policyTemplate => _constants2.cloudPostureIntegrations[policyTemplate].options.map(o => ({
  tooltip: o.tooltip,
  value: o.type,
  id: o.type,
  label: o.name,
  icon: o.icon,
  disabled: o.disabled
}));
exports.getPolicyTemplateInputOptions = getPolicyTemplateInputOptions;