"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CspCustomAssetsExtension = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/fleet-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../common/hooks/use_kibana");
var _constants = require("../../common/navigation/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_APP_NAME = 'securitySolutionUI';
const CspCustomAssetsExtension = () => {
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const views = [{
    name: _constants.cloudPosturePages.dashboard.name,
    url: application.getUrlForApp(SECURITY_APP_NAME, {
      path: _constants.cloudPosturePages.dashboard.path
    }),
    description: _i18n.i18n.translate('xpack.csp.createPackagePolicy.customAssetsTab.dashboardViewLabel', {
      defaultMessage: 'View CSP Dashboard'
    })
  }, {
    name: _constants.cloudPosturePages.findings.name,
    url: application.getUrlForApp(SECURITY_APP_NAME, {
      path: _constants.cloudPosturePages.findings.path
    }),
    description: _i18n.i18n.translate('xpack.csp.createPackagePolicy.customAssetsTab.findingsViewLabel', {
      defaultMessage: 'View CSP Findings '
    })
  }, {
    name: _constants.benchmarksNavigation.rules.name,
    url: application.getUrlForApp(SECURITY_APP_NAME, {
      path: _constants.cloudPosturePages.benchmarks.path
    }),
    description: _i18n.i18n.translate('xpack.csp.createPackagePolicy.customAssetsTab.rulesViewLabel', {
      defaultMessage: 'View CSP Rules '
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_public.CustomAssetsAccordion, {
    views: views,
    initialIsOpen: true
  });
};
// eslint-disable-next-line import/no-default-export
exports.default = exports.CspCustomAssetsExtension = CspCustomAssetsExtension;