"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_AWS_VARS_GROUP = exports.AwsCredentialsForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
var _csp_boxed_radio_group = require("./csp_boxed_radio_group");
var _utils = require("./utils");
var _constants2 = require("../../common/navigation/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AWSSetupInfoContent = ({
  policyTemplate
}) => {
  const {
    cspm,
    kspm
  } = _constants2.cspIntegrationDocsNavigation;
  const integrationLink = !policyTemplate || policyTemplate === _constants.CSPM_POLICY_TEMPLATE ? cspm.getStartedPath : kspm.getStartedPath;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.awsIntegration.setupInfoContentTitle",
    defaultMessage: "Setup Access"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: 'subdued',
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.awsIntegration.setupInfoContent",
    defaultMessage: "The integration will require certain read-only AWS permissions to detect security misconfigurations. Select your preferred method of providing the AWS credentials this integration will use. You can follow these {stepByStepInstructionsLink} to generate the necessary credentials.",
    values: {
      stepByStepInstructionsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: integrationLink,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.awsIntegration.setupInfoContentLink",
        defaultMessage: "step-by-step instructions"
      }))
    }
  })));
};
const AssumeRoleDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.awsIntegration.assumeRoleDescription",
  defaultMessage: "An IAM role Amazon Resource Name (ARN) is an IAM identity that you can create in your AWS account. When creating an IAM role, users can define the role\u2019s permissions. Roles do not have standard long-term credentials such as passwords or access keys."
})));
const DirectAccessKeysDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.awsIntegration.directAccessKeysDescription",
  defaultMessage: "Access keys are long-term credentials for an IAM user or the AWS account root user."
})));
const TemporaryKeysDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.awsIntegration.temporaryKeysDescription",
  defaultMessage: "You can configure temporary security credentials in AWS to last for a specified duration. They consist of an access key ID, a secret access key, and a security token, which is typically found using GetSessionToken."
})));
const SharedCredentialsDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.awsIntegration.sharedCredentialsDescription",
  defaultMessage: "If you use different AWS credentials for different tools or applications, you can use profiles to define multiple access keys in the same configuration file."
})));
const AWS_FIELD_LABEL = {
  access_key_id: _i18n.i18n.translate('xpack.csp.awsIntegration.accessKeyIdLabel', {
    defaultMessage: 'Access Key ID'
  }),
  secret_access_key: _i18n.i18n.translate('xpack.csp.awsIntegration.secretAccessKeyLabel', {
    defaultMessage: 'Secret Access Key'
  })
};
const options = {
  assume_role: {
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.assumeRoleLabel', {
      defaultMessage: 'Assume role'
    }),
    info: AssumeRoleDescription,
    fields: {
      role_arn: {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.roleArnLabel', {
          defaultMessage: 'Role ARN'
        })
      }
    }
  },
  direct_access_keys: {
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.directAccessKeyLabel', {
      defaultMessage: 'Direct access keys'
    }),
    info: DirectAccessKeysDescription,
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password'
      }
    }
  },
  temporary_keys: {
    info: TemporaryKeysDescription,
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.temporaryKeysLabel', {
      defaultMessage: 'Temporary keys'
    }),
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password'
      },
      session_token: {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.sessionTokenLabel', {
          defaultMessage: 'Session Token'
        })
      }
    }
  },
  shared_credentials: {
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.sharedCredentialLabel', {
      defaultMessage: 'Shared credentials'
    }),
    info: SharedCredentialsDescription,
    fields: {
      shared_credential_file: {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.sharedCredentialFileLabel', {
          defaultMessage: 'Shared Credential File'
        })
      },
      credential_profile_name: {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.credentialProfileNameLabel', {
          defaultMessage: 'Credential Profile Name'
        })
      }
    }
  }
};
const DEFAULT_AWS_VARS_GROUP = 'assume_role';
exports.DEFAULT_AWS_VARS_GROUP = DEFAULT_AWS_VARS_GROUP;
const AWS_CREDENTIALS_OPTIONS = Object.keys(options).map(value => ({
  id: value,
  label: options[value].label
}));
const getInputVarsFields = (input, fields) => Object.entries(input.streams[0].vars || {}).filter(([id]) => id in fields).map(([id, inputVar]) => {
  const field = fields[id];
  return {
    id,
    label: field.label,
    type: field.type || 'text',
    value: inputVar.value
  };
});
const getAwsCredentialsType = input => {
  var _input$streams$0$vars;
  return (_input$streams$0$vars = input.streams[0].vars) === null || _input$streams$0$vars === void 0 ? void 0 : _input$streams$0$vars['aws.credentials.type'].value;
};
const AwsCredentialsForm = ({
  input,
  newPolicy,
  updatePolicy
}) => {
  // We only have a value for 'aws.credentials.type' once the form has mounted.
  // On initial render we don't have that value so we default to the first option.
  const awsCredentialsType = getAwsCredentialsType(input) || AWS_CREDENTIALS_OPTIONS[0].id;
  const group = options[awsCredentialsType];
  const fields = getInputVarsFields(input, group.fields);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AWSSetupInfoContent, {
    policyTemplate: input.policy_template
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(AwsCredentialTypeSelector, {
    type: awsCredentialsType,
    onChange: optionId => updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
      'aws.credentials.type': {
        value: optionId
      }
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), group.info, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(AwsInputVarFields, {
    fields: fields,
    onChange: (key, value) => updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
      [key]: {
        value
      }
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.AwsCredentialsForm = AwsCredentialsForm;
const AwsCredentialTypeSelector = ({
  type,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_csp_boxed_radio_group.RadioGroup, {
  size: "s",
  options: [...AWS_CREDENTIALS_OPTIONS],
  idSelected: type,
  onChange: id => onChange(id)
});
const AwsInputVarFields = ({
  fields,
  onChange
}) => /*#__PURE__*/_react.default.createElement("div", null, fields.map(field => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  key: field.id,
  label: field.label,
  fullWidth: true,
  hasChildLabel: true,
  id: field.id
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, field.type === 'password' && /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
  id: field.id,
  type: "dual",
  fullWidth: true,
  value: field.value || '',
  onChange: event => onChange(field.id, event.target.value)
}), field.type === 'text' && /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  id: field.id,
  fullWidth: true,
  value: field.value || '',
  onChange: event => onChange(field.id, event.target.value)
})))));