"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspEvaluationBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// 'fail' / 'pass' are same chars length, but not same width size.
// 46px is used to make sure the badge is always the same width.
const BADGE_WIDTH = '46px';
const getColor = type => {
  if (type === 'passed') return 'success';
  if (type === 'failed') return 'danger';
  return 'default';
};
const CspEvaluationBadge = ({
  type
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: getColor(type),
  css: (0, _react2.css)`
      width: ${BADGE_WIDTH};
      display: flex;
      justify-content: center;
    `,
  "data-test-subj": `${type}_finding`
}, type === 'failed' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.cspEvaluationBadge.failLabel",
  defaultMessage: "Fail"
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.cspEvaluationBadge.passLabel",
  defaultMessage: "Pass"
}));
exports.CspEvaluationBadge = CspEvaluationBadge;