"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspCounterCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Todo: remove when EuiIcon type="pivot" is available
const PivotIcon = ({
  ...props
}) => /*#__PURE__*/_react.default.createElement("svg", (0, _extends2.default)({
  width: "16",
  height: "16",
  fill: "none",
  viewBox: "0 0 16 16"
}, props), /*#__PURE__*/_react.default.createElement("path", {
  fillRule: "evenodd",
  d: "M2.89 13.847 11.239 5.5a.522.522 0 0 0-.737-.737L2.154 13.11a.522.522 0 0 0 .738.738ZM14 6.696a.522.522 0 1 1-1.043 0v-3.13a.522.522 0 0 0-.522-.523h-3.13a.522.522 0 1 1 0-1.043h3.13C13.299 2 14 2.7 14 3.565v3.13Z",
  clipRule: "evenodd"
}));
const CspCounterCard = counter => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    onClick: counter.onClick,
    paddingSize: "m",
    css: (0, _react2.css)`
        position: relative;
        display: flex;
        align-items: center;

        :hover .euiIcon {
          color: ${euiTheme.colors.primary};
          transition: ${euiTheme.animation.normal};
        }
      `,
    "data-test-subj": counter.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    css: {
      height: '100%',
      display: 'flex',
      flexDirection: 'column',
      justifyContent: 'space-around',
      '.euiText h6': {
        textTransform: 'capitalize',
        fontSize: euiTheme.size.m
      }
    },
    titleSize: "s",
    title: counter.title,
    titleColor: counter.titleColor,
    descriptionElement: "h6",
    description: counter.description
  }), counter.onClick && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon
  // Todo: update when EuiIcon type="pivot" is available
  , {
    type: PivotIcon,
    css: (0, _react2.css)`
            color: ${euiTheme.colors.lightShade};
            position: absolute;
            top: ${euiTheme.size.s};
            right: ${euiTheme.size.s};
          `
  }));
};
exports.CspCounterCard = CspCounterCard;