"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComplianceScoreBar = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _helpers = require("../../common/utils/helpers");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component will take 100% of the width set by the parent
 * */
const ComplianceScoreBar = ({
  totalPassed,
  totalFailed
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const complianceScore = (0, _helpers.calculatePostureScore)(totalPassed, totalFailed);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    anchorProps: {
      // ensures the compliance bar takes full width of its parent
      css: (0, _react.css)`
          width: 100%;
        `
    },
    content: _i18n.i18n.translate('xpack.csp.complianceScoreBar.tooltipTitle', {
      defaultMessage: '{failed} failed and {passed} passed findings',
      values: {
        passed: totalPassed,
        failed: totalFailed
      }
    })
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "flexEnd",
    style: {
      gap: euiTheme.size.s
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    style: {
      height: euiTheme.size.xs,
      borderRadius: euiTheme.border.radius.medium,
      overflow: 'hidden',
      gap: 1
    }
  }, !!totalFailed && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    style: {
      flex: totalFailed,
      background: _constants.statusColors.failed
    }
  }), !!totalPassed && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    style: {
      flex: totalPassed,
      background: _constants.statusColors.passed
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    style: {
      fontWeight: euiTheme.font.weight.bold
    }
  }, `${complianceScore.toFixed(0)}%`))));
};
exports.ComplianceScoreBar = ComplianceScoreBar;