"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CISBenchmarkIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cis_eks_logo = _interopRequireDefault(require("../assets/icons/cis_eks_logo.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBenchmarkIdIconType = props => {
  switch (props.type) {
    case 'cis_eks':
      return _cis_eks_logo.default;
    case 'cis_aws':
      return 'logoAWS';
    case 'cis_k8s':
    default:
      return 'logoKubernetes';
  }
};
const CISBenchmarkIcon = props => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: props.name
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: getBenchmarkIdIconType(props),
  size: "xl",
  css: props.style
}));
exports.CISBenchmarkIcon = CISBenchmarkIcon;