"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeverityStatusColor = exports.getCvsScoreColor = void 0;
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCvsScoreColor = score => {
  if (score <= 4) {
    return _uiTheme.euiThemeVars.euiColorVis0; // low severity
  } else if (score >= 4 && score <= 7) {
    return _uiTheme.euiThemeVars.euiColorVis7; // medium severity
  } else if (score >= 7 && score <= 9) {
    return _uiTheme.euiThemeVars.euiColorVis9; // high severity
  } else if (score >= 9) {
    return _uiTheme.euiThemeVars.euiColorDanger; // critical severity
  }
};
exports.getCvsScoreColor = getCvsScoreColor;
const getSeverityStatusColor = severity => {
  switch (severity) {
    case 'LOW':
      return _uiTheme.euiThemeVars.euiColorVis0;
    case 'MEDIUM':
      return _uiTheme.euiThemeVars.euiColorVis7;
    case 'HIGH':
      return _uiTheme.euiThemeVars.euiColorVis9;
    case 'CRITICAL':
      return _uiTheme.euiThemeVars.euiColorDanger;
    default:
      return '#aaa';
  }
};
exports.getSeverityStatusColor = getSeverityStatusColor;