"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateFindingsByResource = exports.useNavigateFindings = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../navigation/constants");
var _query_utils = require("../navigation/query_utils");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFilter = (key, filterValue) => {
  let negate = false;
  let value = filterValue;
  if (typeof filterValue === 'object') {
    negate = filterValue.negate;
    value = filterValue.value;
  }
  return {
    meta: {
      alias: null,
      negate,
      disabled: false,
      type: 'phrase',
      key
    },
    query: {
      match_phrase: {
        [key]: value
      }
    }
  };
};
const useNavigate = pathname => {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services
  } = (0, _use_kibana.useKibana)();
  return (0, _react.useCallback)((filterParams = {}) => {
    const filters = Object.entries(filterParams).map(([key, filterValue]) => createFilter(key, filterValue));
    history.push({
      pathname,
      search: (0, _query_utils.encodeQuery)({
        // Set query language from user's preference
        query: services.data.query.queryString.getDefaultQuery(),
        filters
      })
    });
  }, [pathname, history, services.data.query.queryString]);
};
const useNavigateFindings = () => useNavigate(_constants.findingsNavigation.findings_default.path);
exports.useNavigateFindings = useNavigateFindings;
const useNavigateFindingsByResource = () => useNavigate(_constants.findingsNavigation.findings_by_resource.path);
exports.useNavigateFindingsByResource = useNavigateFindingsByResource;