"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKspmStatsApi = exports.useCspmStatsApi = exports.getStatsRoute = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../hooks/use_kibana");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: consolidate both hooks into one hook with a dynamic key
const getCspmStatsKey = ['csp_cspm_dashboard_stats'];
const getKspmStatsKey = ['csp_kspm_dashboard_stats'];
const getStatsRoute = policyTemplate => {
  return _constants.STATS_ROUTE_PATH.replace('{policy_template}', policyTemplate);
};
exports.getStatsRoute = getStatsRoute;
const useCspmStatsApi = options => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)(getCspmStatsKey, () => http.get(getStatsRoute(_constants.CSPM_POLICY_TEMPLATE)), options);
};
exports.useCspmStatsApi = useCspmStatsApi;
const useKspmStatsApi = options => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)(getKspmStatsKey, () => http.get(getStatsRoute(_constants.KSPM_POLICY_TEMPLATE)), options);
};
exports.useKspmStatsApi = useKspmStatsApi;