"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilteredDataView = void 0;
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *  Returns the common logs-* data view with fields filtered by
 *  fields present in the given index pattern
 */
const useFilteredDataView = indexPattern => {
  const {
    data: {
      dataViews
    }
  } = (0, _public.useKibana)().services;
  const findDataView = async () => {
    var _await$dataViews$find;
    const dataView = (_await$dataViews$find = await dataViews.find(_constants.DATA_VIEW_INDEX_PATTERN)) === null || _await$dataViews$find === void 0 ? void 0 : _await$dataViews$find[0];
    if (!dataView) {
      throw new Error('Findings data view not found');
    }
    const indexPatternFields = await dataViews.getFieldsForWildcard({
      pattern: indexPattern
    });
    if (!indexPatternFields) {
      throw new Error('Error fetching fields for the index pattern');
    }
    dataView.fields = dataView.fields.filter(field => indexPatternFields.some(indexPatternField => indexPatternField.name === field.name));
    return dataView;
  };
  return (0, _reactQuery.useQuery)(['latest_findings_data_view', indexPattern], findDataView);
};
exports.useFilteredDataView = useFilteredDataView;