"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CspRouter = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../common/navigation/constants");
var _security_solution_context = require("./security_solution_context");
var pages = _interopRequireWildcard(require("../pages"));
var _csp_route = require("./csp_route");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const queryClient = new _reactQuery.QueryClient({
  defaultOptions: {
    queries: {
      refetchOnWindowFocus: false
    }
  }
});

/** Props for the cloud security posture router component */

const CspRouter = ({
  securitySolutionContext
}) => {
  const routerElement = /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_csp_route.CspRoute, (0, _extends2.default)({}, _constants.cloudPosturePages.findings, {
    component: pages.Findings
  })), /*#__PURE__*/_react.default.createElement(_csp_route.CspRoute, (0, _extends2.default)({}, _constants.cloudPosturePages.dashboard, {
    component: pages.ComplianceDashboard
  })), /*#__PURE__*/_react.default.createElement(_csp_route.CspRoute, _constants.cloudPosturePages.benchmarks, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_csp_route.CspRoute, (0, _extends2.default)({}, _constants.benchmarksNavigation.rules, {
    component: pages.Rules
  })), /*#__PURE__*/_react.default.createElement(_csp_route.CspRoute, (0, _extends2.default)({}, _constants.cloudPosturePages.benchmarks, {
    component: pages.Benchmarks
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _constants.cloudPosturePages.dashboard.path
  }))));
  if (securitySolutionContext) {
    return /*#__PURE__*/_react.default.createElement(_security_solution_context.SecuritySolutionContext.Provider, {
      value: securitySolutionContext
    }, routerElement);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, routerElement);
};

// Using a default export for usage with `React.lazy`
// eslint-disable-next-line import/no-default-export
exports.default = exports.CspRouter = CspRouter;