"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _register_cloud_deployment_id_analytics_context = require("../common/register_cloud_deployment_id_analytics_context");
var _is_cloud_enabled = require("../common/is_cloud_enabled");
var _constants = require("../common/constants");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "isCloudEnabled", void 0);
    (0, _defineProperty2.default)(this, "contextProviders", []);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.isCloudEnabled = (0, _is_cloud_enabled.getIsCloudEnabled)(this.config.id);
  }
  setup(core) {
    (0, _register_cloud_deployment_id_analytics_context.registerCloudDeploymentMetadataAnalyticsContext)(core.analytics, this.config);
    const {
      id,
      cname,
      base_url: baseUrl,
      trial_end_date: trialEndDate,
      is_elastic_staff_owned: isElasticStaffOwned
    } = this.config;
    return {
      cloudId: id,
      cname,
      baseUrl,
      ...this.getCloudUrls(),
      trialEndDate: trialEndDate ? new Date(trialEndDate) : undefined,
      isElasticStaffOwned,
      isCloudEnabled: this.isCloudEnabled,
      registerCloudService: contextProvider => {
        this.contextProviders.push(contextProvider);
      }
    };
  }
  start(coreStart) {
    coreStart.chrome.setHelpSupportUrl(_constants.ELASTIC_SUPPORT_LINK);

    // Nest all the registered context providers under the Cloud Services Provider.
    // This way, plugins only need to require Cloud's context provider to have all the enriched Cloud services.
    const CloudContextProvider = ({
      children
    }) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.contextProviders.reduce((acc, ContextProvider) => /*#__PURE__*/_react.default.createElement(ContextProvider, null, " ", acc, " "), children));
    };
    const {
      deploymentUrl,
      profileUrl,
      organizationUrl
    } = this.getCloudUrls();
    return {
      CloudContextProvider,
      isCloudEnabled: this.isCloudEnabled,
      cloudId: this.config.id,
      deploymentUrl,
      profileUrl,
      organizationUrl
    };
  }
  stop() {}
  getCloudUrls() {
    const {
      profile_url: profileUrl,
      organization_url: organizationUrl,
      deployment_url: deploymentUrl,
      base_url: baseUrl
    } = this.config;
    const fullCloudDeploymentUrl = (0, _utils.getFullCloudUrl)(baseUrl, deploymentUrl);
    const fullCloudProfileUrl = (0, _utils.getFullCloudUrl)(baseUrl, profileUrl);
    const fullCloudOrganizationUrl = (0, _utils.getFullCloudUrl)(baseUrl, organizationUrl);
    const fullCloudSnapshotsUrl = `${fullCloudDeploymentUrl}/${_constants.CLOUD_SNAPSHOTS_PATH}`;
    return {
      deploymentUrl: fullCloudDeploymentUrl,
      profileUrl: fullCloudProfileUrl,
      organizationUrl: fullCloudOrganizationUrl,
      snapshotsUrl: fullCloudSnapshotsUrl
    };
  }
}
exports.CloudPlugin = CloudPlugin;