"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudLinksPlugin = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _maybe_add_cloud_links = require("./maybe_add_cloud_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudLinksPlugin {
  setup() {}
  start(core, {
    cloud,
    security,
    guidedOnboarding
  }) {
    if (cloud !== null && cloud !== void 0 && cloud.isCloudEnabled && !core.http.anonymousPaths.isAnonymous(window.location.pathname)) {
      var _guidedOnboarding$gui;
      if (guidedOnboarding !== null && guidedOnboarding !== void 0 && (_guidedOnboarding$gui = guidedOnboarding.guidedOnboardingApi) !== null && _guidedOnboarding$gui !== void 0 && _guidedOnboarding$gui.isEnabled) {
        core.chrome.registerGlobalHelpExtensionMenuLink({
          linkType: 'custom',
          href: core.http.basePath.prepend('/app/home#/getting_started'),
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.cloudLinks.setupGuide",
            defaultMessage: "Setup guides"
          }),
          'data-test-subj': 'cloudOnboardingSetupGuideLink',
          priority: 1000 // We want this link to be at the very top.
        });
      }

      if (security) {
        (0, _maybe_add_cloud_links.maybeAddCloudLinks)({
          security,
          chrome: core.chrome,
          cloud
        });
      }
    }
  }
  stop() {}
}
exports.CloudLinksPlugin = CloudLinksPlugin;