"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LaunchDarklyClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LaunchDarklyClient {
  constructor(ldConfig, kibanaVersion) {
    (0, _defineProperty2.default)(this, "launchDarklyClient", void 0);
    this.ldConfig = ldConfig;
    this.kibanaVersion = kibanaVersion;
  }
  async updateUserMetadata(userMetadata) {
    const {
      userId,
      name,
      firstName,
      lastName,
      email,
      avatar,
      ip,
      country,
      ...custom
    } = userMetadata;
    const launchDarklyUser = {
      key: userId,
      name,
      firstName,
      lastName,
      email,
      avatar,
      ip,
      country,
      // This casting is needed because LDUser does not allow `Record<string, undefined>`
      custom: custom
    };
    if (this.launchDarklyClient) {
      await this.launchDarklyClient.identify(launchDarklyUser);
    } else {
      const {
        initialize,
        basicLogger
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('launchdarkly-js-client-sdk')));
      this.launchDarklyClient = initialize(this.ldConfig.client_id, launchDarklyUser, {
        application: {
          id: 'kibana-browser',
          version: this.kibanaVersion
        },
        logger: basicLogger({
          level: this.ldConfig.client_log_level
        })
      });
    }
  }
  async getVariation(configKey, defaultValue) {
    if (!this.launchDarklyClient) return defaultValue; // Skip any action if no LD User is defined
    await this.launchDarklyClient.waitForInitialization();
    return await this.launchDarklyClient.variation(configKey, defaultValue);
  }
  reportMetric(metricName, meta, value) {
    if (!this.launchDarklyClient) return; // Skip any action if no LD User is defined
    this.launchDarklyClient.track(metricName, meta, value);
  }
  stop() {
    var _this$launchDarklyCli;
    (_this$launchDarklyCli = this.launchDarklyClient) === null || _this$launchDarklyCli === void 0 ? void 0 : _this$launchDarklyCli.flush()
    // eslint-disable-next-line no-console
    .catch(err => console.warn(err));
  }
}
exports.LaunchDarklyClient = LaunchDarklyClient;