"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineGetCloudDefendStatusRoute = exports.INDEX_TIMEOUT_IN_MINUTES = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../../common/constants");
var _fleet_util = require("../../lib/fleet_util");
var _check_index_status = require("../../lib/check_index_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_TIMEOUT_IN_MINUTES = 10;
exports.INDEX_TIMEOUT_IN_MINUTES = INDEX_TIMEOUT_IN_MINUTES;
const calculateDiffFromNowInMinutes = date => (0, _moment.default)().diff((0, _moment.default)(date), 'minutes');
const getHealthyAgents = async (soClient, installedCloudDefendPackagePolicies, agentPolicyService, agentService, logger) => {
  // Get agent policies of package policies (from installed package policies)
  const agentPolicies = await (0, _fleet_util.getCloudDefendAgentPolicies)(soClient, installedCloudDefendPackagePolicies, agentPolicyService);

  // Get agents statuses of the following agent policies
  const agentStatusesByAgentPolicyId = await (0, _fleet_util.getAgentStatusesByAgentPolicies)(agentService, agentPolicies, logger);
  return Object.values(agentStatusesByAgentPolicyId).reduce((sum, status) => sum + status.online + status.updating, 0);
};
const calculateCloudDefendStatusCode = (indicesStatus, installedCloudDefendPackagePolicies, healthyAgents, timeSinceInstallationInMinutes) => {
  // We check privileges only for the relevant indices for our pages to appear
  if (indicesStatus.alerts === 'unprivileged') return 'unprivileged';
  if (indicesStatus.alerts === 'not-empty') return 'indexed';
  if (installedCloudDefendPackagePolicies === 0) return 'not-installed';
  if (healthyAgents === 0) return 'not-deployed';
  if (timeSinceInstallationInMinutes <= INDEX_TIMEOUT_IN_MINUTES) return 'indexing';
  if (timeSinceInstallationInMinutes > INDEX_TIMEOUT_IN_MINUTES) return 'index-timeout';
  throw new Error('Could not determine cloud defend status');
};
const assertResponse = (resp, logger) => {
  if (resp.status === 'unprivileged' && !resp.indicesDetails.some(idxDetails => idxDetails.status === 'unprivileged')) {
    logger.warn('Returned status in `unprivileged` but response is missing the unprivileged index');
  }
};
const getCloudDefendStatus = async ({
  logger,
  esClient,
  soClient,
  packageService,
  packagePolicyService,
  agentPolicyService,
  agentService
}) => {
  const [alertsIndexStatus, installation, latestCloudDefendPackage, installedPackagePolicies, installedPolicyTemplates] = await Promise.all([(0, _check_index_status.checkIndexStatus)(esClient.asCurrentUser, _constants.ALERTS_INDEX_PATTERN, logger), packageService.asInternalUser.getInstallation(_constants.INTEGRATION_PACKAGE_NAME), packageService.asInternalUser.fetchFindLatestPackage(_constants.INTEGRATION_PACKAGE_NAME), (0, _fleet_util.getCloudDefendPackagePolicies)(soClient, packagePolicyService, _constants.INTEGRATION_PACKAGE_NAME, {
    per_page: 10000
  }), (0, _fleet_util.getInstalledPolicyTemplates)(packagePolicyService, soClient)]);
  const healthyAgents = await getHealthyAgents(soClient, installedPackagePolicies.items, agentPolicyService, agentService, logger);
  const installedPackagePoliciesTotal = installedPackagePolicies.total;
  const latestCloudDefendPackageVersion = latestCloudDefendPackage.version;
  const MIN_DATE = 0;
  const indicesDetails = [{
    index: _constants.ALERTS_INDEX_PATTERN,
    status: alertsIndexStatus
  }];
  const status = calculateCloudDefendStatusCode({
    alerts: alertsIndexStatus
  }, installedPackagePoliciesTotal, healthyAgents, calculateDiffFromNowInMinutes((installation === null || installation === void 0 ? void 0 : installation.install_started_at) || MIN_DATE));
  if (status === 'not-installed') return {
    status,
    indicesDetails,
    latestPackageVersion: latestCloudDefendPackageVersion,
    healthyAgents,
    installedPackagePolicies: installedPackagePoliciesTotal
  };
  const response = {
    status,
    indicesDetails,
    latestPackageVersion: latestCloudDefendPackageVersion,
    healthyAgents,
    installedPolicyTemplates,
    installedPackagePolicies: installedPackagePoliciesTotal,
    installedPackageVersion: installation === null || installation === void 0 ? void 0 : installation.install_version
  };
  assertResponse(response, logger);
  return response;
};
const defineGetCloudDefendStatusRoute = router => router.get({
  path: _constants.STATUS_ROUTE_PATH,
  validate: {},
  options: {
    tags: ['access:cloud-defend-read']
  }
}, async (context, request, response) => {
  const cloudDefendContext = await context.cloudDefend;
  try {
    const status = await getCloudDefendStatus(cloudDefendContext);
    return response.ok({
      body: status
    });
  } catch (err) {
    cloudDefendContext.logger.error(`Error getting cloud_defend status`);
    cloudDefendContext.logger.error(err);
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineGetCloudDefendStatusRoute = defineGetCloudDefendStatusRoute;