"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudDefendPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _setup_routes = require("./routes/setup_routes");
var _helpers = require("../common/utils/helpers");
var _subscription = require("../common/utils/subscription");
var _fleet_util = require("./lib/fleet_util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudDefendPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "isCloudEnabled", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, plugins) {
    this.logger.debug('cloudDefend: Setup');
    (0, _setup_routes.setupRoutes)({
      core,
      logger: this.logger
    });
    this.isCloudEnabled = plugins.cloud.isCloudEnabled;
    return {};
  }
  start(core, plugins) {
    this.logger.debug('cloudDefend: Started');
    plugins.fleet.fleetSetupCompleted().then(async () => {
      plugins.fleet.registerExternalCallback('packagePolicyCreate', async packagePolicy => {
        var _packagePolicy$packag;
        const license = await plugins.licensing.refresh();
        if ((0, _helpers.isCloudDefendPackage)((_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name)) {
          if (!(0, _subscription.isSubscriptionAllowed)(this.isCloudEnabled, license)) {
            throw new Error('To use this feature you must upgrade your subscription or start a trial');
          }
        }
        return packagePolicy;
      });
    });
    plugins.fleet.registerExternalCallback('packagePolicyPostCreate', async (packagePolicy, soClient) => {
      var _packagePolicy$packag2;
      if ((0, _helpers.isCloudDefendPackage)((_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name)) {
        await (0, _fleet_util.onPackagePolicyPostCreateCallback)(this.logger, packagePolicy, soClient);
        return packagePolicy;
      }
      return packagePolicy;
    });
    return {};
  }
  stop() {}
}
exports.CloudDefendPlugin = CloudDefendPlugin;