"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecuritySolutionNavTab = exports.getSecuritySolutionLink = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets the cloud_defend link properties of a Cloud Defend page for navigation in the security solution.
 * @param cloudDefendPage the name of the cloud defend page.
 */
const getSecuritySolutionLink = cloudDefendPage => {
  return {
    id: _constants.cloudDefendPages[cloudDefendPage].id,
    title: _constants.cloudDefendPages[cloudDefendPage].name,
    path: _constants.cloudDefendPages[cloudDefendPage].path
  };
};

/**
 * Gets the link properties of a Cloud Defend page for navigation in the old security solution navigation.
 * @param cloudDefendPage the name of the cloud defend page.
 * @param basePath the base path for links.
 */
exports.getSecuritySolutionLink = getSecuritySolutionLink;
const getSecuritySolutionNavTab = (cloudDefendPage, basePath) => ({
  id: _constants.cloudDefendPages[cloudDefendPage].id,
  name: _constants.cloudDefendPages[cloudDefendPage].name,
  href: `${basePath}${_constants.cloudDefendPages[cloudDefendPage].path}`,
  disabled: !!_constants.cloudDefendPages[cloudDefendPage].disabled
});
exports.getSecuritySolutionNavTab = getSecuritySolutionNavTab;