"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePageSize = void 0;
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @description handles persisting the users table row size selection
 */
const usePageSize = localStorageKey => {
  const [persistedPageSize, setPersistedPageSize] = (0, _useLocalStorage.default)(localStorageKey, _constants.DEFAULT_VISIBLE_ROWS_PER_PAGE);
  let pageSize = _constants.DEFAULT_VISIBLE_ROWS_PER_PAGE;
  if (persistedPageSize) {
    pageSize = persistedPageSize;
  }
  return {
    pageSize,
    setPageSize: setPersistedPageSize
  };
};
exports.usePageSize = usePageSize;