"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALID_SELECTOR_NAME_REGEX = exports.MAX_SELECTOR_NAME_LENGTH = exports.MAX_SELECTORS_AND_RESPONSES_PER_TYPE = exports.MAX_CONDITION_VALUE_LENGTH_BYTES = exports.MAX_CONDITION_VALUE_LENGTH = exports.LOCAL_STORAGE_PAGE_SIZE = exports.FIM_OPERATIONS = exports.DEFAULT_VISIBLE_ROWS_PER_PAGE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_VISIBLE_ROWS_PER_PAGE = 10; // generic default # of table rows to show (currently we only have a list of policies)
exports.DEFAULT_VISIBLE_ROWS_PER_PAGE = DEFAULT_VISIBLE_ROWS_PER_PAGE;
const LOCAL_STORAGE_PAGE_SIZE = 'cloudDefend:userPageSize';
exports.LOCAL_STORAGE_PAGE_SIZE = LOCAL_STORAGE_PAGE_SIZE;
const VALID_SELECTOR_NAME_REGEX = /^[a-z0-9][a-z0-9_\-]*$/i; // alphanumberic (no - or _ allowed on first char)
exports.VALID_SELECTOR_NAME_REGEX = VALID_SELECTOR_NAME_REGEX;
const MAX_SELECTORS_AND_RESPONSES_PER_TYPE = 64;
exports.MAX_SELECTORS_AND_RESPONSES_PER_TYPE = MAX_SELECTORS_AND_RESPONSES_PER_TYPE;
const MAX_SELECTOR_NAME_LENGTH = 128; // chars
exports.MAX_SELECTOR_NAME_LENGTH = MAX_SELECTOR_NAME_LENGTH;
const MAX_CONDITION_VALUE_LENGTH_BYTES = 511; // max length for all condition values. some props override this in cloud_defend/public/types.ts

// TODO: temporary until I change condition value length checks in the yaml editor view to be byte based.
exports.MAX_CONDITION_VALUE_LENGTH_BYTES = MAX_CONDITION_VALUE_LENGTH_BYTES;
const MAX_CONDITION_VALUE_LENGTH = 64;
exports.MAX_CONDITION_VALUE_LENGTH = MAX_CONDITION_VALUE_LENGTH;
const FIM_OPERATIONS = ['createFile', 'modifyFile', 'deleteFile'];
exports.FIM_OPERATIONS = FIM_OPERATIONS;