"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudDataMigrationPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _common = require("../common");
var _breadcrumbs = require("./application/services/breadcrumbs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class CloudDataMigrationPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "breadcrumbService", new _breadcrumbs.BreadcrumbService());
  }
  setup(core, {
    cloud,
    management
  }) {
    // Only be applies to self-managed instances of Kibana. Any Kibana instance running on
    // Elastic Cloud should not show any information related to migration.
    if (!cloud.isCloudEnabled) {
      management.sections.section.data.registerApp({
        id: _common.PLUGIN_ID,
        title: _common.PLUGIN_NAME,
        order: 8,
        mount: async params => {
          const [coreStart] = await core.getStartServices();
          const {
            setBreadcrumbs
          } = params;

          // Initialize services
          this.breadcrumbService.setup(setBreadcrumbs);
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          // Render the application
          const unmountAppCallback = renderApp(coreStart, this.breadcrumbService, params);
          return () => {
            unmountAppCallback();
          };
        }
      });
    }
  }
  start(core, {
    cloud
  }) {
    if (!(cloud !== null && cloud !== void 0 && cloud.isCloudEnabled)) {
      core.chrome.registerGlobalHelpExtensionMenuLink({
        linkType: 'custom',
        target: '_blank',
        href: 'https://ela.st/cloud-migration',
        content: _i18n.i18n.translate('xpack.cloudDataMigration.helpMenuMoveDataTitle', {
          defaultMessage: 'Move data to Elastic Cloud'
        }),
        'data-test-subj': 'migrate_data_to_cloud__help_menu_link',
        priority: 200,
        external: true
      });
    }
  }
  stop() {}
}
exports.CloudDataMigrationPlugin = CloudDataMigrationPlugin;