"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAppStyles = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAppStyles = euiTheme => {
  return {
    listItemCss: (0, _react.css)`
      font-weight: ${euiTheme.font.weight.light};
    `,
    panelCss: (0, _react.css)`
      padding: calc(${euiTheme.size.xxxl});
      margin: ${euiTheme.size.l} auto;
      width: 100%;
      max-width: 875px;
    `,
    illustrationCss: (0, _react.css)`
      max-width: 75%;
    `,
    layoutCss: (0, _react.css)`
      max-width: 500px;
      margin: 0 auto;
    `
  };
};
exports.getAppStyles = getAppStyles;