"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LegendToggleComponent = ({
  onClick,
  showLegend,
  legendPosition
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const baseStyles = (0, _react.useMemo)(() => (0, _react2.css)`
      position: absolute;
      bottom: 0;
      left: 0;
      z-index: 1;
      margin: ${euiTheme.size.xs};
    `, [euiTheme.size.xs]);
  const isOpenStyle = (0, _react.useMemo)(() => (0, _react2.css)`
      background-color: ${euiTheme.colors.lightestShade};
    `, [euiTheme.colors.lightestShade]);
  const positionStyle = (0, _react.useMemo)(() => (0, _react2.css)`
      left: auto;
      bottom: auto;
      right: 0;
      top: 0;
    `, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    type: "button",
    iconType: "list",
    color: "text",
    onClick: onClick,
    css: [baseStyles, showLegend ? isOpenStyle : null, ['left', 'bottom'].includes(legendPosition) ? positionStyle : null],
    "aria-label": _i18n.i18n.translate('charts.legend.toggleLegendButtonAriaLabel', {
      defaultMessage: 'Toggle legend'
    }),
    "aria-expanded": showLegend,
    isSelected: showLegend,
    "data-test-subj": "vislibToggleLegend",
    title: _i18n.i18n.translate('charts.legend.toggleLegendButtonTitle', {
      defaultMessage: 'Toggle legend'
    })
  });
};
const LegendToggle = /*#__PURE__*/(0, _react.memo)(LegendToggleComponent);
exports.LegendToggle = LegendToggle;