"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConnectorUserAction = exports.testConnectorId = exports.pushConnectorUserAction = exports.createUserActionSO = exports.createUserActionFindSO = exports.createPersistableStateUserAction = exports.createExternalReferenceUserAction = exports.createConnectorUserAction = exports.createCaseUserAction = void 0;
var _server = require("@kbn/actions-plugin/server");
var _lodash = require("lodash");
var _constants = require("../../../common/constants");
var _api = require("../../../common/api");
var _constants2 = require("../../common/constants");
var _test_utils = require("../test_utils");
var _mocks = require("../../attachment_framework/mocks");
var _transform = require("./transform");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createUserActionFindSO = userAction => ({
  ...userAction,
  score: 0
});
exports.createUserActionFindSO = createUserActionFindSO;
const createConnectorUserAction = overrides => {
  const {
    id,
    ...restConnector
  } = (0, _test_utils.createConnectorObject)().connector;
  return {
    ...createUserActionSO({
      action: _api.Actions.create,
      payload: {
        connector: restConnector
      },
      type: 'connector',
      connectorId: id
    }),
    ...(overrides && {
      ...overrides
    })
  };
};
exports.createConnectorUserAction = createConnectorUserAction;
const createUserActionSO = ({
  action,
  attributesOverrides,
  commentId,
  connectorId,
  pushedConnectorId,
  payload,
  type,
  references = []
}) => {
  const defaultParams = {
    action,
    created_at: 'abc',
    created_by: {
      email: 'a',
      username: 'b',
      full_name: 'abc'
    },
    type: type !== null && type !== void 0 ? type : 'title',
    payload: payload !== null && payload !== void 0 ? payload : {
      title: 'a new title'
    },
    owner: 'securitySolution'
  };
  return {
    type: _constants.CASE_USER_ACTION_SAVED_OBJECT,
    id: '100',
    attributes: {
      ...defaultParams,
      ...(attributesOverrides && {
        ...attributesOverrides
      })
    },
    references: [...references, {
      type: _constants.CASE_SAVED_OBJECT,
      name: _constants2.CASE_REF_NAME,
      id: '1'
    }, ...(commentId ? [{
      type: _constants.CASE_COMMENT_SAVED_OBJECT,
      name: _constants2.COMMENT_REF_NAME,
      id: commentId
    }] : []), ...(connectorId ? [{
      type: _server.ACTION_SAVED_OBJECT_TYPE,
      name: _constants2.CONNECTOR_ID_REFERENCE_NAME,
      id: connectorId
    }] : []), ...(pushedConnectorId ? [{
      type: _server.ACTION_SAVED_OBJECT_TYPE,
      name: _constants2.PUSH_CONNECTOR_ID_REFERENCE_NAME,
      id: pushedConnectorId
    }] : [])]
  };
};
exports.createUserActionSO = createUserActionSO;
const updateConnectorUserAction = ({
  overrides
} = {}) => {
  const {
    id,
    ...restConnector
  } = (0, _test_utils.createJiraConnector)();
  return {
    ...createUserActionSO({
      action: _api.Actions.update,
      payload: {
        connector: restConnector
      },
      type: 'connector',
      connectorId: id
    }),
    ...(overrides && {
      ...overrides
    })
  };
};
exports.updateConnectorUserAction = updateConnectorUserAction;
const pushConnectorUserAction = ({
  overrides
} = {}) => {
  const {
    connector_id: connectorId,
    ...restExternalService
  } = (0, _test_utils.createExternalService)();
  return {
    ...createUserActionSO({
      action: _api.Actions.push_to_service,
      payload: {
        externalService: restExternalService
      },
      pushedConnectorId: connectorId,
      type: 'pushed'
    }),
    ...(overrides && {
      ...overrides
    })
  };
};
exports.pushConnectorUserAction = pushConnectorUserAction;
const createCaseUserAction = () => {
  const {
    id,
    ...restConnector
  } = (0, _test_utils.createJiraConnector)();
  return {
    ...createUserActionSO({
      action: _api.Actions.create,
      payload: {
        connector: restConnector,
        title: 'a title',
        description: 'a desc',
        settings: {
          syncAlerts: false
        },
        status: _api.CaseStatuses.open,
        severity: _api.CaseSeverity.LOW,
        tags: [],
        owner: _constants.SECURITY_SOLUTION_OWNER
      },
      connectorId: id,
      type: 'create_case'
    })
  };
};
exports.createCaseUserAction = createCaseUserAction;
const createPersistableStateUserAction = () => {
  return {
    ...createUserActionSO({
      action: _api.Actions.create,
      commentId: 'persistable-state-test-id',
      payload: {
        comment: {
          ..._mocks.persistableStateAttachment,
          persistableStateAttachmentState: {
            foo: 'foo'
          }
        }
      },
      type: 'comment',
      references: [{
        id: 'testRef',
        name: 'myTestReference',
        type: 'test-so'
      }]
    })
  };
};
exports.createPersistableStateUserAction = createPersistableStateUserAction;
const createExternalReferenceUserAction = () => {
  return {
    ...createUserActionSO({
      action: _api.Actions.create,
      commentId: 'external-reference-test-id',
      payload: {
        comment: (0, _lodash.omit)(_mocks.externalReferenceAttachmentSO, 'externalReferenceId')
      },
      type: 'comment',
      references: [{
        id: 'my-id',
        name: _constants2.EXTERNAL_REFERENCE_REF_NAME,
        type: 'test-so'
      }]
    })
  };
};
exports.createExternalReferenceUserAction = createExternalReferenceUserAction;
const testConnectorId = (persistableStateAttachmentTypeRegistry, userAction, path, expectedConnectorId = '1') => {
  it('does set payload.connector.id to none when it cannot find the reference', () => {
    const userActionWithEmptyRef = {
      ...userAction,
      references: []
    };
    const transformed = (0, _transform.transformFindResponseToExternalModel)((0, _test_utils.createSOFindResponse)([createUserActionFindSO(userActionWithEmptyRef)]), persistableStateAttachmentTypeRegistry);
    expect((0, _lodash.get)(transformed.saved_objects[0].attributes.payload, path)).toBe('none');
  });
  it('does not populate the payload.connector.id when the reference exists but the action is not of type connector', () => {
    const invalidUserAction = {
      ...userAction,
      attributes: {
        ...userAction.attributes,
        type: 'not-connector'
      }
    };
    const transformed = (0, _transform.transformFindResponseToExternalModel)((0, _test_utils.createSOFindResponse)([createUserActionFindSO(invalidUserAction)]), persistableStateAttachmentTypeRegistry);
    expect((0, _lodash.get)(transformed.saved_objects[0].attributes.payload, path)).toBeUndefined();
  });
  it('does not populate the payload.connector.id when the reference exists but the payload does not contain a connector', () => {
    const invalidUserAction = {
      ...userAction,
      attributes: {
        ...userAction.attributes,
        payload: {}
      }
    };
    const transformed = (0, _transform.transformFindResponseToExternalModel)((0, _test_utils.createSOFindResponse)([createUserActionFindSO(invalidUserAction)]), persistableStateAttachmentTypeRegistry);
    expect((0, _lodash.get)(transformed.saved_objects[0].attributes.payload, path)).toBeUndefined();
  });
  it('populates the payload.connector.id', () => {
    const transformed = (0, _transform.transformFindResponseToExternalModel)((0, _test_utils.createSOFindResponse)([createUserActionFindSO(userAction)]), persistableStateAttachmentTypeRegistry);
    expect((0, _lodash.get)(transformed.saved_objects[0].attributes.payload, path)).toEqual(expectedConnectorId);
  });
};
exports.testConnectorId = testConnectorId;