"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PushedUserActionBuilder = void 0;
var _constants = require("../../../../common/constants");
var _api = require("../../../../common/api");
var _abstract_builder = require("../abstract_builder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PushedUserActionBuilder extends _abstract_builder.UserActionBuilder {
  build(args) {
    const action = _api.Actions.push_to_service;
    const parameters = this.buildCommonUserAction({
      ...args,
      action,
      valueKey: 'externalService',
      value: this.extractConnectorIdFromExternalService(args.payload.externalService),
      type: _api.ActionTypes.pushed,
      connectorId: args.payload.externalService.connector_id
    });
    const getMessage = id => `User pushed case id: ${args.caseId} to an external service with connector id: ${args.payload.externalService.connector_id} - user action id: ${id}`;
    const eventDetails = {
      getMessage,
      action,
      descriptiveAction: 'case_user_action_pushed_case',
      savedObjectId: args.caseId,
      savedObjectType: _constants.CASE_SAVED_OBJECT
    };
    return {
      parameters,
      eventDetails
    };
  }
}
exports.PushedUserActionBuilder = PushedUserActionBuilder;