"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssigneesUserActionBuilder = void 0;
var _constants = require("../../../../common/constants");
var _api = require("../../../../common/api");
var _abstract_builder = require("../abstract_builder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AssigneesUserActionBuilder extends _abstract_builder.UserActionBuilder {
  build(args) {
    var _args$action;
    const action = (_args$action = args.action) !== null && _args$action !== void 0 ? _args$action : _api.Actions.add;
    const soParams = this.buildCommonUserAction({
      ...args,
      action,
      valueKey: 'assignees',
      value: args.payload.assignees,
      type: _api.ActionTypes.assignees
    });
    const uids = args.payload.assignees.map(assignee => assignee.uid);
    const verbMessage = getVerbMessage(action, uids);
    const getMessage = id => `User ${verbMessage} case id: ${args.caseId} - user action id: ${id}`;
    const event = {
      getMessage,
      action,
      descriptiveAction: `case_user_action_${action}_case_assignees`,
      savedObjectId: args.caseId,
      savedObjectType: _constants.CASE_SAVED_OBJECT
    };
    return {
      parameters: soParams,
      eventDetails: event
    };
  }
}
exports.AssigneesUserActionBuilder = AssigneesUserActionBuilder;
const getVerbMessage = (action, uids) => {
  const uidText = `uids: [${uids}]`;
  switch (action) {
    case 'add':
      return `assigned ${uidText} to`;
    case 'delete':
      return `unassigned ${uidText} from`;
    default:
      return `changed ${uidText} for`;
  }
};