"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESCaseStatus = exports.ESCaseSeverity = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * This type should only be used within the cases service and its helper functions (e.g. the transforms).
 *
 * The type represents how the external services portion of the object will be layed out when stored in ES. The external_service will have its
 * connector_id field removed and placed within the references field.
 */
let ESCaseSeverity;
exports.ESCaseSeverity = ESCaseSeverity;
(function (ESCaseSeverity) {
  ESCaseSeverity[ESCaseSeverity["LOW"] = 0] = "LOW";
  ESCaseSeverity[ESCaseSeverity["MEDIUM"] = 10] = "MEDIUM";
  ESCaseSeverity[ESCaseSeverity["HIGH"] = 20] = "HIGH";
  ESCaseSeverity[ESCaseSeverity["CRITICAL"] = 30] = "CRITICAL";
})(ESCaseSeverity || (exports.ESCaseSeverity = ESCaseSeverity = {}));
let ESCaseStatus;
/**
 * This type should only be used within the cases service and its helper functions (e.g. the transforms).
 *
 * The type represents how the Cases object will be layed out in ES.
 * 1 - It will not have connector.id or external_service.connector_id. Instead those fields will be transformed into the references field.
 * 2 - The Severity type is internally a number.
 */
exports.ESCaseStatus = ESCaseStatus;
(function (ESCaseStatus) {
  ESCaseStatus[ESCaseStatus["OPEN"] = 0] = "OPEN";
  ESCaseStatus[ESCaseStatus["IN_PROGRESS"] = 10] = "IN_PROGRESS";
  ESCaseStatus[ESCaseStatus["CLOSED"] = 20] = "CLOSED";
})(ESCaseStatus || (exports.ESCaseStatus = ESCaseStatus = {}));