"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.caseConnectorMappingsSavedObjectType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _constants = require("../../common/constants");
var _migrations = require("./migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The comments in the mapping indicate the additional properties that are stored in Elasticsearch but are not indexed.
 * Remove these comments when https://github.com/elastic/kibana/issues/152756 is resolved.
 */

const caseConnectorMappingsSavedObjectType = {
  name: _constants.CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT,
  indexPattern: _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX,
  hidden: true,
  namespaceType: 'multiple-isolated',
  convertToMultiNamespaceTypeVersion: '8.0.0',
  mappings: {
    dynamic: false,
    properties: {
      /*
      mappings: {
        properties: {
          source: {
            type: 'keyword',
          },
          target: {
            type: 'keyword',
          },
          action_type: {
            type: 'keyword',
          },
        },
      },
      */
      owner: {
        type: 'keyword'
      }
    }
  },
  migrations: _migrations.connectorMappingsMigrations
};
exports.caseConnectorMappingsSavedObjectType = caseConnectorMappingsSavedObjectType;