"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInternalRoutes = void 0;
var _get_connectors = require("./internal/get_connectors");
var _get_case_user_actions_stats = require("./internal/get_case_user_actions_stats");
var _bulk_create_attachments = require("./internal/bulk_create_attachments");
var _bulk_get_cases = require("./internal/bulk_get_cases");
var _suggest_user_profiles = require("./internal/suggest_user_profiles");
var _bulk_get_attachments = require("./internal/bulk_get_attachments");
var _get_case_users = require("./internal/get_case_users");
var _bulk_delete_file_attachments = require("./internal/bulk_delete_file_attachments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInternalRoutes = userProfileService => [_bulk_create_attachments.bulkCreateAttachmentsRoute, (0, _suggest_user_profiles.suggestUserProfilesRoute)(userProfileService), _get_connectors.getConnectorsRoute, _bulk_get_cases.bulkGetCasesRoute, _get_case_user_actions_stats.getCaseUserActionStatsRoute, _bulk_get_attachments.bulkGetAttachmentsRoute, _get_case_users.getCaseUsersRoute, _bulk_delete_file_attachments.bulkDeleteFileAttachments];
exports.getInternalRoutes = getInternalRoutes;