"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInternalAttachments = void 0;
var _boom = require("@hapi/boom");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _api = require("../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerInternalAttachments = externalRefRegistry => {
  externalRefRegistry.register({
    id: _api.FILE_ATTACHMENT_TYPE,
    schemaValidator
  });
};
exports.registerInternalAttachments = registerInternalAttachments;
const schemaValidator = data => {
  const fileMetadata = (0, _pipeable.pipe)((0, _api.excess)(_api.FileAttachmentMetadataRt).decode(data), (0, _Either.fold)((0, _api.throwErrors)(_boom.badRequest), _function.identity));
  if (fileMetadata.files.length > 1) {
    throw (0, _boom.badRequest)('Only a single file can be stored in an attachment');
  }
};