"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUserRequests = exports.createFileRequests = exports.createAlertRequests = void 0;
var _api = require("../../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createUserRequests = num => {
  const requests = [...Array(num).keys()].map(value => {
    return {
      comment: `${value}`,
      type: _api.CommentType.user,
      owner: 'test'
    };
  });
  return requests;
};
exports.createUserRequests = createUserRequests;
const createFileRequests = ({
  numRequests,
  numFiles
}) => {
  const files = [...Array(numFiles).keys()].map(value => {
    return {
      name: `${value}`,
      created: '2023-02-27T20:26:54.345Z',
      extension: 'png',
      mimeType: 'image/png'
    };
  });
  const requests = [...Array(numRequests).keys()].map(value => {
    return {
      type: _api.CommentType.externalReference,
      externalReferenceAttachmentTypeId: _api.FILE_ATTACHMENT_TYPE,
      externalReferenceId: 'so-id',
      externalReferenceMetadata: {
        files
      },
      externalReferenceStorage: {
        soType: `${value}`,
        type: _api.ExternalReferenceStorageType.savedObject
      },
      owner: 'test'
    };
  });
  return requests;
};
exports.createFileRequests = createFileRequests;
const createAlertRequests = (numberOfRequests, alertIds) => {
  const requests = [...Array(numberOfRequests).keys()].map(value => {
    return {
      type: _api.CommentType.alert,
      alertId: alertIds,
      index: alertIds,
      rule: {
        id: null,
        name: null
      },
      owner: `${value}`
    };
  });
  return requests;
};
exports.createAlertRequests = createAlertRequests;