"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATUS_EXTERNAL_TO_ESMODEL = exports.STATUS_ESMODEL_TO_EXTERNAL = exports.SEVERITY_EXTERNAL_TO_ESMODEL = exports.SEVERITY_ESMODEL_TO_EXTERNAL = exports.PUSH_CONNECTOR_ID_REFERENCE_NAME = exports.LICENSING_CASE_ASSIGNMENT_FEATURE = exports.EXTERNAL_REFERENCE_REF_NAME = exports.CONNECTOR_ID_REFERENCE_NAME = exports.COMMENT_REF_NAME = exports.CASE_REF_NAME = void 0;
var _api = require("../../common/api");
var _constants = require("../../common/constants");
var _types = require("../services/cases/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The name of the saved object reference indicating the action connector ID. This is stored in the Saved Object reference
 * field's name property.
 */
const CONNECTOR_ID_REFERENCE_NAME = 'connectorId';

/**
 * The name of the saved object reference indicating the action connector ID that was used to push a case.
 */
exports.CONNECTOR_ID_REFERENCE_NAME = CONNECTOR_ID_REFERENCE_NAME;
const PUSH_CONNECTOR_ID_REFERENCE_NAME = 'pushConnectorId';

/**
 * The name of the saved object reference indicating the caseId reference
 */
exports.PUSH_CONNECTOR_ID_REFERENCE_NAME = PUSH_CONNECTOR_ID_REFERENCE_NAME;
const CASE_REF_NAME = `associated-${_constants.CASE_SAVED_OBJECT}`;

/**
 * The name of the saved object reference indicating the commentId reference
 */
exports.CASE_REF_NAME = CASE_REF_NAME;
const COMMENT_REF_NAME = `associated-${_constants.CASE_COMMENT_SAVED_OBJECT}`;

/**
 * The name of the saved object reference indicating the externalReferenceId reference
 */
exports.COMMENT_REF_NAME = COMMENT_REF_NAME;
const EXTERNAL_REFERENCE_REF_NAME = 'externalReferenceId';

/**
 * The name of the licensing feature to notify for feature usage with the licensing plugin
 */
exports.EXTERNAL_REFERENCE_REF_NAME = EXTERNAL_REFERENCE_REF_NAME;
const LICENSING_CASE_ASSIGNMENT_FEATURE = 'Cases user assignment';
exports.LICENSING_CASE_ASSIGNMENT_FEATURE = LICENSING_CASE_ASSIGNMENT_FEATURE;
const SEVERITY_EXTERNAL_TO_ESMODEL = {
  [_api.CaseSeverity.LOW]: _types.ESCaseSeverity.LOW,
  [_api.CaseSeverity.MEDIUM]: _types.ESCaseSeverity.MEDIUM,
  [_api.CaseSeverity.HIGH]: _types.ESCaseSeverity.HIGH,
  [_api.CaseSeverity.CRITICAL]: _types.ESCaseSeverity.CRITICAL
};
exports.SEVERITY_EXTERNAL_TO_ESMODEL = SEVERITY_EXTERNAL_TO_ESMODEL;
const SEVERITY_ESMODEL_TO_EXTERNAL = {
  [_types.ESCaseSeverity.LOW]: _api.CaseSeverity.LOW,
  [_types.ESCaseSeverity.MEDIUM]: _api.CaseSeverity.MEDIUM,
  [_types.ESCaseSeverity.HIGH]: _api.CaseSeverity.HIGH,
  [_types.ESCaseSeverity.CRITICAL]: _api.CaseSeverity.CRITICAL
};
exports.SEVERITY_ESMODEL_TO_EXTERNAL = SEVERITY_ESMODEL_TO_EXTERNAL;
const STATUS_EXTERNAL_TO_ESMODEL = {
  [_api.CaseStatuses.open]: _types.ESCaseStatus.OPEN,
  [_api.CaseStatuses['in-progress']]: _types.ESCaseStatus.IN_PROGRESS,
  [_api.CaseStatuses.closed]: _types.ESCaseStatus.CLOSED
};
exports.STATUS_EXTERNAL_TO_ESMODEL = STATUS_EXTERNAL_TO_ESMODEL;
const STATUS_ESMODEL_TO_EXTERNAL = {
  [_types.ESCaseStatus.OPEN]: _api.CaseStatuses.open,
  [_types.ESCaseStatus.IN_PROGRESS]: _api.CaseStatuses['in-progress'],
  [_types.ESCaseStatus.CLOSED]: _api.CaseStatuses.closed
};
exports.STATUS_ESMODEL_TO_EXTERNAL = STATUS_ESMODEL_TO_EXTERNAL;