"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatSavedObjects = exports.extractAttributes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractAttributes = userActions => {
  return userActions.saved_objects.map(so => so.attributes);
};
exports.extractAttributes = extractAttributes;
const formatSavedObjects = response => response.saved_objects.map(so => {
  var _so$version;
  return {
    id: so.id,
    version: (_so$version = so.version) !== null && _so$version !== void 0 ? _so$version : '',
    ...so.attributes
  };
});
exports.formatSavedObjects = formatSavedObjects;