"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSuggestUserProfiles = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _lodash = require("lodash");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("../translations"));
var _kibana = require("../../common/lib/kibana");
var _constants2 = require("../constants");
var _api = require("./api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Time in ms until the data become stale.
 * We set the stale time to one minute
 * to prevent fetching the same queries
 * while the user is typing.
 */

const STALE_TIME = 1000 * 60;
const useSuggestUserProfiles = ({
  name,
  owners,
  size = _constants.DEFAULT_USER_SIZE,
  onDebounce = _lodash.noop
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const [debouncedName, setDebouncedName] = (0, _react.useState)(name);
  (0, _useDebounce.default)(() => {
    setDebouncedName(name);
    onDebounce();
  }, _constants.SEARCH_DEBOUNCE_MS, [name]);
  const toasts = (0, _kibana.useToasts)();
  return (0, _reactQuery.useQuery)(_constants2.casesQueriesKeys.suggestUsers({
    name: debouncedName,
    owners,
    size
  }), () => {
    const abortCtrlRef = new AbortController();
    return (0, _api.suggestUserProfiles)({
      http,
      name: debouncedName,
      owners,
      size,
      signal: abortCtrlRef.signal
    });
  }, {
    retry: false,
    keepPreviousData: true,
    staleTime: STALE_TIME,
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: i18n.ERROR_TITLE
        });
      }
    }
  });
};
exports.useSuggestUserProfiles = useSuggestUserProfiles;