"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateComment = void 0;
var _react = require("react");
var _kibana = require("../common/lib/kibana");
var _use_cases_context = require("../components/cases_context/use_cases_context");
var _use_on_refresh_case_view_page = require("../components/case_view/use_on_refresh_case_view_page");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataFetchReducer = (state, action) => {
  switch (action.type) {
    case 'FETCH_INIT':
      return {
        ...state,
        isLoadingIds: [...state.isLoadingIds, action.payload],
        isError: false
      };
    case 'FETCH_SUCCESS':
      return {
        ...state,
        isLoadingIds: state.isLoadingIds.filter(id => action.payload.commentId !== id),
        isError: false
      };
    case 'FETCH_FAILURE':
      return {
        ...state,
        isLoadingIds: state.isLoadingIds.filter(id => action.payload !== id),
        isError: true
      };
    default:
      return state;
  }
};
const useUpdateComment = () => {
  const [state, dispatch] = (0, _react.useReducer)(dataFetchReducer, {
    isLoadingIds: [],
    isError: false
  });
  const toasts = (0, _kibana.useToasts)();
  const isCancelledRef = (0, _react.useRef)(false);
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  // this hook guarantees that there will be at least one value in the owner array, we'll
  // just use the first entry just in case there are more than one entry
  const owner = (0, _use_cases_context.useCasesContext)().owner[0];
  const refreshCaseViewPage = (0, _use_on_refresh_case_view_page.useRefreshCaseViewPage)();
  const dispatchUpdateComment = (0, _react.useCallback)(async ({
    caseId,
    commentId,
    commentUpdate,
    version
  }) => {
    try {
      isCancelledRef.current = false;
      abortCtrlRef.current.abort();
      abortCtrlRef.current = new AbortController();
      dispatch({
        type: 'FETCH_INIT',
        payload: commentId
      });
      await (0, _api.patchComment)({
        caseId,
        commentId,
        commentUpdate,
        version,
        signal: abortCtrlRef.current.signal,
        owner
      });
      if (!isCancelledRef.current) {
        refreshCaseViewPage();
        dispatch({
          type: 'FETCH_SUCCESS',
          payload: {
            commentId
          }
        });
      }
    } catch (error) {
      if (!isCancelledRef.current) {
        if (error.name !== 'AbortError') {
          toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
            title: i18n.ERROR_TITLE
          });
        }
        dispatch({
          type: 'FETCH_FAILURE',
          payload: commentId
        });
      }
    }
  }, [owner, refreshCaseViewPage, toasts]);
  (0, _react.useEffect)(() => () => {
    isCancelledRef.current = true;
    abortCtrlRef.current.abort();
  }, []);
  return {
    ...state,
    patchComment: dispatchUpdateComment
  };
};
exports.useUpdateComment = useUpdateComment;